/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.network;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.powers.data.AllomancerCapability;
import com.legobmw99.allomancy.network.Network;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class UpdateBurnPacket {
    private final Metal mt;
    private final boolean value;

    public UpdateBurnPacket(Metal mt, boolean value) {
        this.mt = mt;
        this.value = value;
    }

    public static UpdateBurnPacket decode(FriendlyByteBuf buf) {
        return new UpdateBurnPacket((Metal)buf.m_130066_(Metal.class), buf.readBoolean());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.mt);
        buf.writeBoolean(this.value);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
                if (data.hasPower(this.mt) && data.getStored(this.mt) > 0) {
                    data.setBurning(this.mt, this.value);
                    if (!this.value && this.mt == Metal.DURALUMIN) {
                        data.drainMetals((Metal[])Arrays.stream(Metal.values()).filter(data::isBurning).toArray(Metal[]::new));
                    }
                    if (!this.value && data.isEnhanced()) {
                        data.drainMetals(this.mt);
                    }
                } else {
                    data.setBurning(this.mt, false);
                }
                Network.sync(data, player);
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

