/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.network;

import com.legobmw99.allomancy.modules.powers.data.AllomancerCapability;
import com.legobmw99.allomancy.network.Network;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class UpdateEnhancedPacket {
    private final int enhance_time;
    private final int entityID;

    public UpdateEnhancedPacket(boolean enhanced, int entityID) {
        this.enhance_time = enhanced ? 100 : 0;
        this.entityID = entityID;
    }

    public UpdateEnhancedPacket(int enhance_time, int entityID) {
        this.enhance_time = enhance_time;
        this.entityID = entityID;
    }

    public static UpdateEnhancedPacket decode(FriendlyByteBuf buf) {
        return new UpdateEnhancedPacket(buf.readInt(), buf.readInt());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.enhance_time);
        buf.writeInt(this.entityID);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                Player player = (Player)((NetworkEvent.Context)ctx.get()).getSender().m_9236_().m_6815_(this.entityID);
                if (player instanceof ServerPlayer) {
                    ServerPlayer p = (ServerPlayer)player;
                    player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
                        data.setEnhanced(this.enhance_time);
                        Network.sync(new UpdateEnhancedPacket(this.enhance_time, this.entityID), p);
                    });
                }
            } else {
                Player player = (Player)Minecraft.m_91087_().f_91073_.m_6815_(this.entityID);
                if (player != null) {
                    player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> data.setEnhanced(this.enhance_time));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

