/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.util;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.modules.powers.entity.ai.AIAttackOnCollideExtended;
import com.legobmw99.allomancy.modules.powers.entity.ai.AIEvilAttack;
import com.legobmw99.allomancy.util.AllomancyTags;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class Emotional {
    private static final Predicate<Goal> isAggroGoal = goal -> goal instanceof SwellGoal || goal instanceof AIAttackOnCollideExtended || goal instanceof MeleeAttackGoal || goal instanceof TargetGoal || goal instanceof PanicGoal || goal.getClass().getName().contains("Fireball") || goal.getClass().getName().contains("Attack") || goal.getClass().getName().contains("Anger");

    public static void riot(PathfinderMob target, Player allomancer, boolean enhanced) {
        try {
            if (!enhanced) {
                if (Emotional.hasTinFoilHat((LivingEntity)target)) {
                    return;
                }
                target.f_21346_.m_25374_(Goal.Flag.TARGET);
                target.m_6710_((LivingEntity)allomancer);
                target.m_6703_((LivingEntity)allomancer);
                target.f_21346_.m_25352_(1, (Goal)new AIAttackOnCollideExtended(target, 1.0, false));
                target.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)target, Player.class, false));
                target.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)target, target.getClass(), false));
                target.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)target));
                target.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal(target, new Class[0]).m_26044_(new Class[0]));
                if (target.m_21051_(Attributes.f_22281_) != null && !(target instanceof Guardian)) {
                    target.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal(target, 1.2, true));
                }
                target.m_21561_(true);
                if (target instanceof Creeper) {
                    Creeper creeper = (Creeper)target;
                    target.f_21345_.m_25352_(1, (Goal)new SwellGoal(creeper));
                }
                if (target instanceof Rabbit) {
                    Rabbit rabbit = (Rabbit)target;
                    target.f_21345_.m_25352_(1, (Goal)new AIEvilAttack(rabbit));
                }
                if (target instanceof AbstractSkeleton) {
                    AbstractSkeleton skeleton = (AbstractSkeleton)target;
                    target.f_21345_.m_25352_(1, (Goal)new RangedBowAttackGoal((Monster)skeleton, 1.0, 20, 15.0f));
                }
                if (target instanceof Illusioner) {
                    Illusioner illusioner = (Illusioner)target;
                    target.f_21345_.m_25352_(1, (Goal)new RangedBowAttackGoal((Monster)illusioner, 0.5, 20, 15.0f));
                }
                if (target instanceof Pillager) {
                    Pillager pillager = (Pillager)target;
                    target.f_21345_.m_25352_(2, (Goal)new RangedCrossbowAttackGoal((Monster)pillager, 1.0, 8.0f));
                }
            } else {
                target.m_9236_().m_255391_((Entity)target, target.m_20182_().m_7096_(), target.m_20182_().m_7098_(), target.m_20182_().m_7094_(), 1.2f, false, Level.ExplosionInteraction.MOB);
                target.m_6074_();
            }
        }
        catch (Exception e) {
            Allomancy.LOGGER.error("Failed to riot entity " + String.valueOf(target) + "! Please report this error!", (Throwable)e);
        }
    }

    public static void soothe(PathfinderMob target, Player allomancer, boolean enhanced) {
        try {
            if (!enhanced) {
                if (Emotional.hasTinFoilHat((LivingEntity)target)) {
                    return;
                }
                if (target.m_21525_()) {
                    target.m_21557_(false);
                }
                target.f_21345_.m_25386_().filter(isAggroGoal).forEach(WrappedGoal::m_8041_);
                target.f_21346_.m_25386_().filter(isAggroGoal).forEach(WrappedGoal::m_8041_);
                target.f_21345_.m_25373_();
                target.f_21346_.m_25373_();
                target.m_6710_(null);
                target.m_6703_(null);
                target.f_21346_.m_25355_(Goal.Flag.TARGET);
                target.m_21561_(false);
                target.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)target, Player.class, 6.0f));
                if (target instanceof TamableAnimal) {
                    TamableAnimal animal = (TamableAnimal)target;
                    if (Math.random() < 0.3) {
                        animal.m_21828_(allomancer);
                    }
                }
                if (target instanceof AbstractHorse) {
                    AbstractHorse horse = (AbstractHorse)target;
                    if (Math.random() < 0.3) {
                        horse.m_30637_(allomancer);
                    }
                }
                if (target instanceof Sheep) {
                    target.f_21345_.m_25352_(1, (Goal)new EatBlockGoal((Mob)target));
                }
                if (target instanceof Villager) {
                    Villager villager = (Villager)target;
                    villager.m_6814_(ReputationEventType.f_26989_, (Entity)allomancer);
                }
                if (target instanceof WanderingTrader) {
                    target.f_21345_.m_25352_(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)target));
                }
            } else {
                target.m_21557_(true);
            }
        }
        catch (Exception e) {
            Allomancy.LOGGER.error("Failed to soothe entity " + String.valueOf(target) + "! Please report this error!", (Throwable)e);
        }
    }

    public static boolean hasTinFoilHat(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.HEAD).m_204117_(AllomancyTags.TIN_FOIL_HATS);
    }
}

