/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.util;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.powers.data.AllomancerCapability;
import com.legobmw99.allomancy.network.Network;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class Enhancement {
    public static void wipePlayer(Player player) {
        player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
            data.drainMetals(Metal.values());
            player.m_21219_();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                Network.syncAllomancerData(sp);
            }
        });
    }

    private static void teleport(Player player, Level world, ResourceKey<Level> dimension, final BlockPos pos) {
        if (!world.f_46443_ && player != null) {
            if (player.m_20159_()) {
                player.m_8127_();
            }
            if (player.m_9236_().m_46472_() != dimension) {
                player = (Player)player.changeDimension(world.m_7654_().m_129880_(dimension), new ITeleporter(){

                    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                        Entity repositionedEntity = repositionEntity.apply(false);
                        repositionedEntity.m_6021_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                        return repositionedEntity;
                    }
                });
            }
            player.m_20324_((double)pos.m_123341_(), (double)pos.m_123342_() + 1.5, (double)pos.m_123343_());
            player.f_19789_ = 0.0f;
        }
    }

    public static void teleportToLastDeath(Player curPlayer, Level level, IAllomancerData data) {
        curPlayer.m_219759_().ifPresent(death -> {
            Enhancement.teleport(curPlayer, level, (ResourceKey<Level>)death.m_122640_(), death.m_122646_());
            if (data.isBurning(Metal.DURALUMIN)) {
                data.drainMetals(Metal.DURALUMIN);
            }
            data.drainMetals(Metal.GOLD);
        });
    }

    public static void teleportToSpawn(Player curPlayer, Level level, IAllomancerData data) {
        BlockPos spawnLoc;
        ResourceKey spawnDim;
        GlobalPos spawn = data.getSpawnLoc();
        if (spawn != null) {
            spawnDim = spawn.m_122640_();
            spawnLoc = spawn.m_122646_();
        } else {
            spawnDim = Level.f_46428_;
            spawnLoc = new BlockPos(level.m_6106_().m_6789_(), level.m_6106_().m_6527_(), level.m_6106_().m_6526_());
        }
        Enhancement.teleport(curPlayer, level, (ResourceKey<Level>)spawnDim, spawnLoc);
        if (data.isBurning(Metal.DURALUMIN)) {
            data.drainMetals(Metal.DURALUMIN);
        }
        data.drainMetals(Metal.ELECTRUM);
    }

    public static void wipeNearby(Player curPlayer, Level level) {
        if (level instanceof ServerLevel) {
            int max = 20;
            Vec3 negative = curPlayer.m_20182_().m_82520_((double)(-max), (double)(-max), (double)(-max));
            Vec3 positive = curPlayer.m_20182_().m_82520_((double)max, (double)max, (double)max);
            level.m_45976_(Player.class, new AABB(negative, positive)).forEach(otherPlayer -> otherPlayer.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> data.drainMetals(Metal.values())));
        }
    }
}

