/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.world;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.world.block.LerasiumFluid;
import com.legobmw99.allomancy.modules.world.block.LiquidLerasiumBlock;
import com.legobmw99.allomancy.modules.world.client.WorldClientSetup;
import com.legobmw99.allomancy.modules.world.loot.LootTableInjector;
import com.legobmw99.allomancy.modules.world.recipe.InvestingRecipe;
import com.legobmw99.allomancy.util.AllomancyTags;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class WorldSetup {
    public static final OreConfig[] ORE_METALS = new OreConfig[]{new OreConfig("aluminum", 9, 11, 40, 120), new OreConfig("cadmium", 7, 4, -60, 0), new OreConfig("chromium", 6, 6, -30, 30), new OreConfig("lead", 9, 12, -40, 30), new OreConfig("silver", 7, 8, -40, 30), new OreConfig("tin", 11, 12, 30, 112), new OreConfig("zinc", 8, 9, 40, 80)};
    public static final ResourceKey<Structure> WELL = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)Allomancy.rl("well"));
    private static final ResourceKey<StructureTemplatePool> WELL_POOL = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)Allomancy.rl("well_pool"));
    private static final ResourceKey<StructureSet> WELLS = ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)Allomancy.rl("wells"));
    private static final ResourceKey<BiomeModifier> ADD_ALLOMANCY_ORES = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Allomancy.rl("overworld_ores"));
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"allomancy");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"allomancy");
    private static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"allomancy");
    private static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.f_256808_, (String)"allomancy");
    public static final Supplier<FluidType> LERAS_TYPE = FLUID_TYPES.register("lerasium", () -> new FluidType(FluidType.Properties.create().canConvertToSource(false).lightLevel(14).canHydrate(false).canSwim(false).supportsBoating(false).canDrown(false).rarity(Rarity.EPIC).pathType(BlockPathTypes.LAVA)){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new WorldClientSetup.LerasiumFluidExtension());
        }
    });
    public static final Supplier<FlowingFluid> LERASIUM_FLUID = FLUIDS.register("lerasium", () -> new LerasiumFluid(WorldSetup.makeProps()));
    public static final RegistryObject<LiquidLerasiumBlock> LIQUID_LERASIUM = BLOCKS.register("liquid_lerasium", () -> new LiquidLerasiumBlock(LERASIUM_FLUID, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283811_).m_60910_().m_60978_(100.0f).m_278166_(PushReaction.DESTROY).m_222994_().m_60953_(state -> 14).m_278788_().m_60918_(SoundType.f_279557_)));
    public static final List<RegistryObject<Item>> FLAKES = new ArrayList<RegistryObject<Item>>();
    public static final List<RegistryObject<Item>> NUGGETS = new ArrayList<RegistryObject<Item>>();
    public static final List<RegistryObject<Item>> INGOTS = new ArrayList<RegistryObject<Item>>();
    public static final List<RegistryObject<Block>> STORAGE_BLOCKS = new ArrayList<RegistryObject<Block>>();
    public static final List<RegistryObject<Item>> STORAGE_BLOCK_ITEMS = new ArrayList<RegistryObject<Item>>();
    public static final List<RegistryObject<Block>> ORE_BLOCKS = new ArrayList<RegistryObject<Block>>();
    public static final List<RegistryObject<Item>> ORE_BLOCKS_ITEMS = new ArrayList<RegistryObject<Item>>();
    public static final List<RegistryObject<Block>> DEEPSLATE_ORE_BLOCKS = new ArrayList<RegistryObject<Block>>();
    public static final List<RegistryObject<Item>> DEEPSLATE_ORE_BLOCKS_ITEMS = new ArrayList<RegistryObject<Item>>();
    public static final List<RegistryObject<Block>> RAW_ORE_BLOCKS = new ArrayList<RegistryObject<Block>>();
    public static final List<RegistryObject<Item>> RAW_ORE_BLOCKS_ITEMS = new ArrayList<RegistryObject<Item>>();
    public static final List<RegistryObject<Item>> RAW_ORE_ITEMS = new ArrayList<RegistryObject<Item>>();
    public static int METAL_ITEM_LEN = Metal.values().length;
    public static final int LEAD = METAL_ITEM_LEN++;
    public static final int SILVER = METAL_ITEM_LEN++;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPES;
    public static final Supplier<RecipeSerializer<InvestingRecipe>> INVESTING_RECIPE_SERIALIZER;
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPES;
    public static final Supplier<RecipeType<InvestingRecipe>> INVESTING_RECIPE;

    private static ForgeFlowingFluid.Properties makeProps() {
        return new ForgeFlowingFluid.Properties(LERAS_TYPE, LERASIUM_FLUID, LERASIUM_FLUID).block(LIQUID_LERASIUM).explosionResistance(100.0f).levelDecreasePerBlock(8);
    }

    public static void register() {
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        FLUID_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        FLUIDS.register(FMLJavaModLoadingContext.get().getModEventBus());
        RECIPE_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        RECIPES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static void init(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> MinecraftForge.EVENT_BUS.register(LootTableInjector.class));
    }

    public static Block createStandardBlock() {
        return new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(2.1f).m_60999_());
    }

    public static Block createStandardOre() {
        return new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_));
    }

    public static Block createDeepslateBlock() {
        return new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152468_).m_60913_(4.5f, 3.0f));
    }

    public static Item createStandardItem() {
        return new Item(new Item.Properties());
    }

    public static void bootstrapConfigured(BootstapContext<ConfiguredFeature<?, ?>> bootstrap) {
        TagMatchTest stone = new TagMatchTest(BlockTags.f_144266_);
        TagMatchTest deepslate = new TagMatchTest(BlockTags.f_144267_);
        for (int i = 0; i < ORE_METALS.length; ++i) {
            OreConfig ore = ORE_METALS[i];
            RegistryObject<Block> ore_block = ORE_BLOCKS.get(i);
            RegistryObject<Block> deepslate_ore_block = DEEPSLATE_ORE_BLOCKS.get(i);
            bootstrap.m_255272_(ore.getRegistryKey(Registries.f_256911_, "_ore_feature"), (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)stone, (BlockState)((Block)ore_block.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslate, (BlockState)((Block)deepslate_ore_block.get()).m_49966_())), ore.size())));
        }
    }

    public static void bootstrapPlaced(BootstapContext<PlacedFeature> bootstrap) {
        for (OreConfig ore : ORE_METALS) {
            HolderGetter configured = bootstrap.m_255420_(Registries.f_256911_);
            bootstrap.m_255272_(ore.getRegistryKey(Registries.f_256988_, "_ore"), (Object)new PlacedFeature((Holder)configured.m_255043_(ore.getRegistryKey(Registries.f_256911_, "_ore_feature")), List.of(CountPlacement.m_191628_((int)ore.placementCount), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)ore.minHeight), (VerticalAnchor)VerticalAnchor.m_158922_((int)ore.maxHeight)), BiomeFilter.m_191561_())));
        }
    }

    public static void bootstrapBiomeModifier(BootstapContext<BiomeModifier> bootstrap) {
        HolderSet.Named overworldTag = bootstrap.m_255420_(Registries.f_256952_).m_254956_(BiomeTags.f_215817_);
        HolderGetter placed = bootstrap.m_255420_(Registries.f_256988_);
        ArrayList<Holder.Reference> ores = new ArrayList<Holder.Reference>();
        for (OreConfig ore : ORE_METALS) {
            ores.add(placed.m_255043_(ore.getRegistryKey(Registries.f_256988_, "_ore")));
        }
        bootstrap.m_255272_(ADD_ALLOMANCY_ORES, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, (HolderSet)HolderSet.m_205800_(ores), GenerationStep.Decoration.UNDERGROUND_ORES));
    }

    public static void bootstrapStructures(BootstapContext<Structure> BootstapContext2) {
        BootstapContext2.m_255272_(WELL, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)BootstapContext2.m_255420_(Registries.f_256952_).m_254956_(AllomancyTags.SPAWNS_WELLS), Map.of(MobCategory.AMBIENT, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146332_()), MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146332_())), GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.NONE), (Holder)BootstapContext2.m_255420_(Registries.f_256948_).m_255043_(WELL_POOL), Optional.empty(), 1, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)-16)), false, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 3));
    }

    public static void bootstrapTemplatePools(BootstapContext<StructureTemplatePool> BootstapContext2) {
        BootstapContext2.m_255272_(WELL_POOL, (Object)new StructureTemplatePool((Holder)BootstapContext2.m_255420_(Registries.f_256948_).m_255043_(Pools.f_127186_), List.of(Pair.of((Object)StructurePoolElement.m_210526_((String)Allomancy.rl("mountain_well").toString()), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    public static void bootstrapStructureSets(BootstapContext<StructureSet> BootstapContext2) {
        BootstapContext2.m_255272_(WELLS, (Object)new StructureSet((Holder)BootstapContext2.m_255420_(Registries.f_256944_).m_255043_(WELL), (StructurePlacement)new RandomSpreadStructurePlacement(Vec3i.f_123288_, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, 161616, Optional.empty(), 16, 8, RandomSpreadType.LINEAR)));
    }

    static {
        for (Metal metal : Metal.values()) {
            String name = metal.getName();
            FLAKES.add((RegistryObject<Item>)ITEMS.register(name + "_flakes", WorldSetup::createStandardItem));
            if (metal.isVanilla()) {
                NUGGETS.add(null);
                INGOTS.add(null);
                STORAGE_BLOCKS.add(null);
                STORAGE_BLOCK_ITEMS.add(null);
                continue;
            }
            NUGGETS.add((RegistryObject<Item>)ITEMS.register(name + "_nugget", WorldSetup::createStandardItem));
            INGOTS.add((RegistryObject<Item>)ITEMS.register(name + "_ingot", WorldSetup::createStandardItem));
            STORAGE_BLOCKS.add((RegistryObject<Block>)BLOCKS.register(name + "_block", WorldSetup::createStandardBlock));
            STORAGE_BLOCK_ITEMS.add((RegistryObject<Item>)ITEMS.register(name + "_block", () -> new BlockItem((Block)STORAGE_BLOCKS.get(mt.getIndex()).get(), new Item.Properties())));
        }
        FLAKES.add((RegistryObject<Item>)ITEMS.register("lead_flakes", WorldSetup::createStandardItem));
        NUGGETS.add((RegistryObject<Item>)ITEMS.register("lead_nugget", WorldSetup::createStandardItem));
        INGOTS.add((RegistryObject<Item>)ITEMS.register("lead_ingot", WorldSetup::createStandardItem));
        STORAGE_BLOCKS.add((RegistryObject<Block>)BLOCKS.register("lead_block", WorldSetup::createStandardBlock));
        STORAGE_BLOCK_ITEMS.add((RegistryObject<Item>)ITEMS.register("lead_block", () -> new BlockItem((Block)STORAGE_BLOCKS.get(LEAD).get(), new Item.Properties())));
        FLAKES.add((RegistryObject<Item>)ITEMS.register("silver_flakes", WorldSetup::createStandardItem));
        NUGGETS.add((RegistryObject<Item>)ITEMS.register("silver_nugget", WorldSetup::createStandardItem));
        INGOTS.add((RegistryObject<Item>)ITEMS.register("silver_ingot", WorldSetup::createStandardItem));
        STORAGE_BLOCKS.add((RegistryObject<Block>)BLOCKS.register("silver_block", WorldSetup::createStandardBlock));
        STORAGE_BLOCK_ITEMS.add((RegistryObject<Item>)ITEMS.register("silver_block", () -> new BlockItem((Block)STORAGE_BLOCKS.get(SILVER).get(), new Item.Properties())));
        for (OreConfig oreConfig : ORE_METALS) {
            RegistryObject ore_block = BLOCKS.register(String.valueOf(oreConfig) + "_ore", WorldSetup::createStandardOre);
            ORE_BLOCKS.add((RegistryObject<Block>)ore_block);
            ORE_BLOCKS_ITEMS.add((RegistryObject<Item>)ITEMS.register(String.valueOf(oreConfig) + "_ore", () -> new BlockItem((Block)ore_block.get(), new Item.Properties())));
            RegistryObject ds_ore_block = BLOCKS.register("deepslate_" + String.valueOf(oreConfig) + "_ore", WorldSetup::createDeepslateBlock);
            DEEPSLATE_ORE_BLOCKS.add((RegistryObject<Block>)ds_ore_block);
            DEEPSLATE_ORE_BLOCKS_ITEMS.add((RegistryObject<Item>)ITEMS.register("deepslate_" + String.valueOf(oreConfig) + "_ore", () -> new BlockItem((Block)ds_ore_block.get(), new Item.Properties())));
            RegistryObject raw_ore_block = BLOCKS.register("raw_" + String.valueOf(oreConfig) + "_block", WorldSetup::createStandardBlock);
            RAW_ORE_BLOCKS.add((RegistryObject<Block>)raw_ore_block);
            RAW_ORE_BLOCKS_ITEMS.add((RegistryObject<Item>)ITEMS.register("raw_" + String.valueOf(oreConfig) + "_block", () -> new BlockItem((Block)raw_ore_block.get(), new Item.Properties())));
            RAW_ORE_ITEMS.add((RegistryObject<Item>)ITEMS.register("raw_" + String.valueOf(oreConfig), WorldSetup::createStandardItem));
        }
        RECIPES = DeferredRegister.create((ResourceKey)Registries.f_256764_, (String)"allomancy");
        INVESTING_RECIPE_SERIALIZER = RECIPES.register("investing", () -> new RecipeSerializer<InvestingRecipe>(){

            public InvestingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
                Ingredient ingredient = Ingredient.m_288218_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient"), (boolean)false);
                String s1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"result");
                int i = GsonHelper.m_13927_((JsonObject)pJson, (String)"count");
                ItemStack itemstack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(s1)), i);
                return new InvestingRecipe(pRecipeId, ingredient, itemstack);
            }

            public InvestingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
                Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
                ItemStack itemstack = pBuffer.m_130267_();
                return new InvestingRecipe(pRecipeId, ingredient, itemstack);
            }

            public void toNetwork(FriendlyByteBuf pBuffer, InvestingRecipe pRecipe) {
                pRecipe.getIngredient().m_43923_(pBuffer);
                pBuffer.m_130055_(pRecipe.getResult());
            }
        });
        RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256954_, (String)"allomancy");
        INVESTING_RECIPE = RECIPE_TYPES.register("investing", () -> RecipeType.simple((ResourceLocation)Allomancy.rl("investing")));
    }

    public record OreConfig(String name, int size, int placementCount, int minHeight, int maxHeight) {
        <T> ResourceKey<T> getRegistryKey(ResourceKey<Registry<T>> registry, String suffix) {
            return ResourceKey.m_135785_(registry, (ResourceLocation)Allomancy.rl(this.name + suffix));
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

