/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredcycles.events;

import com.sapphic.kindredcycles.abilities.GuardianRegenAbilityType;
import com.sapphic.kindredcycles.abilities.WardRegenAbilityType;
import com.sapphic.kindredcycles.events.RegenEventHandler;
import com.sapphic.kindredcycles.network.C2S_HealWardPacket;
import com.sapphic.kindredcycles.setup.ClientSetup;
import com.sapphic.kindredsouls.api.IAbilityType;
import com.sapphic.kindredsouls.api.IKindredSoulsAPI;
import com.sapphic.kindredsouls.api.client.AbilityLoreRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.sapphic.kindredcycles.KindredCyclesMod;

@Mod.EventBusSubscriber(modid="kindred_cycles", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEvents {
    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            KindredCyclesMod.addNetworkMessage(C2S_HealWardPacket.class, C2S_HealWardPacket::toBytes, C2S_HealWardPacket::new, C2S_HealWardPacket::handle);
            KindredCyclesMod.LOGGER.info("Kindred Souls and Regeneration mods found. Initializing bridge...");
            MinecraftForge.EVENT_BUS.register((Object)new RegenEventHandler());
            try {
                IKindredSoulsAPI.getInstance().getAbilityRegistry().register((IAbilityType)GuardianRegenAbilityType.INSTANCE);
                IKindredSoulsAPI.getInstance().getAbilityRegistry().register((IAbilityType)WardRegenAbilityType.INSTANCE);
                KindredCyclesMod.LOGGER.info("Successfully registered Kindred Cycles abilities for Guardian and Ward!");
            }
            catch (Exception e) {
                KindredCyclesMod.LOGGER.error("Could not register Kindred Cycles abilities.", (Throwable)e);
            }
        });
    }

    @Mod.EventBusSubscriber(modid="kindred_cycles", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ClientSetup.initClient();
            event.enqueueWork(() -> {
                AbilityLoreRegistry.register((ResourceLocation)GuardianRegenAbilityType.INSTANCE.getId(), (Component)GuardianRegenAbilityType.INSTANCE.getDescription(), (Component)GuardianRegenAbilityType.INSTANCE.getLore());
                AbilityLoreRegistry.register((ResourceLocation)WardRegenAbilityType.INSTANCE.getId(), (Component)WardRegenAbilityType.INSTANCE.getDescription(), (Component)WardRegenAbilityType.INSTANCE.getLore());
            });
        }

        @SubscribeEvent
        public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
            ClientSetup.registerKeyMappings(event);
        }
    }
}

