/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredcycles.events;

import com.sapphic.kindredcycles.abilities.GuardianRegenAbilityType;
import com.sapphic.kindredcycles.abilities.WardRegenAbilityType;
import com.sapphic.kindredsouls.api.IKindredSoulsAPI;
import com.sapphic.kindredsouls.api.events.SoulbindHurtEvent;
import java.util.Optional;
import java.util.UUID;
import mc.craig.software.regen.common.regen.RegenerationData;
import mc.craig.software.regen.common.regen.state.RegenStates;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.sapphic.kindredcycles.KindredCyclesMod;

public class RegenEventHandler {
    private static final String NBT_REGENS_GRANTED = "kindred_cycles_regens_granted";

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().m_5776_() || event.player.f_19797_ % 20 != 0) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        CompoundTag data = player.getPersistentData();
        boolean hasBeenGrantedRegens = data.m_128471_(NBT_REGENS_GRANTED);
        try {
            IKindredSoulsAPI ksApi = IKindredSoulsAPI.getInstance();
            ResourceLocation currentAbilityId = ksApi.getPlayerAbilityType(player);
            if (GuardianRegenAbilityType.ID.equals((Object)currentAbilityId) || WardRegenAbilityType.ID.equals((Object)currentAbilityId)) {
                if (!hasBeenGrantedRegens) {
                    RegenerationData.get((LivingEntity)player).ifPresent(regenData -> {
                        if (regenData.regens() <= 0) {
                            KindredCyclesMod.LOGGER.info("Granting 12 regenerations to " + player.m_7755_().getString() + " for choosing a regen ability.");
                            regenData.setRegens(12);
                            regenData.syncToClients(player);
                            player.m_213846_((Component)Component.m_237115_((String)"message.kindred_cycles.regens_granted"));
                        }
                        data.m_128379_(NBT_REGENS_GRANTED, true);
                    });
                }
            } else if (hasBeenGrantedRegens) {
                data.m_128379_(NBT_REGENS_GRANTED, false);
            }
        }
        catch (Exception e) {
            KindredCyclesMod.LOGGER.error("Error in Kindred Cycles player tick event", (Throwable)e);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onSoulbindDamage(SoulbindHurtEvent event) {
        ServerPlayer damagedPlayer = event.getPlayer();
        String playerRole = event.getPlayerRole();
        ServerPlayer soulmate = event.getSoulmate();
        LivingHurtEvent originalEvent = event.getOriginalEvent();
        if (soulmate == null || soulmate.m_21224_()) {
            return;
        }
        try {
            IKindredSoulsAPI ksApi = IKindredSoulsAPI.getInstance();
            ResourceLocation playerAbility = ksApi.getPlayerAbilityType(damagedPlayer);
            ResourceLocation soulmateAbility = ksApi.getPlayerAbilityType(soulmate);
            ServerPlayer guardian = null;
            ServerPlayer ward = null;
            if ("WARD".equals(playerRole) && WardRegenAbilityType.ID.equals((Object)playerAbility) && GuardianRegenAbilityType.ID.equals((Object)soulmateAbility)) {
                ward = damagedPlayer;
                guardian = soulmate;
            } else if ("GUARDIAN".equals(playerRole) && GuardianRegenAbilityType.ID.equals((Object)playerAbility) && WardRegenAbilityType.ID.equals((Object)soulmateAbility)) {
                guardian = damagedPlayer;
                ward = soulmate;
            } else {
                return;
            }
            if (damagedPlayer == ward) {
                float originalDamage = originalEvent.getAmount();
                if (originalDamage >= Float.MAX_VALUE) {
                    event.setCanceled(true);
                    return;
                }
                float damageToWard = originalDamage * 0.5f;
                float damageToGuardian = originalDamage * 0.5f;
                guardian.m_19880_().add("kindredsouls_damaging");
                guardian.m_6469_(originalEvent.getSource(), damageToGuardian);
                originalEvent.setAmount(damageToWard);
                event.setCanceled(true);
            } else {
                event.setCanceled(true);
            }
        }
        catch (Exception e) {
            KindredCyclesMod.LOGGER.error("Error in Kindred Cycles damage handler", (Throwable)e);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (event.getEntity().m_9236_().f_46443_ || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        try {
            IKindredSoulsAPI ksApi = IKindredSoulsAPI.getInstance();
            ResourceLocation abilityId = ksApi.getPlayerAbilityType(player);
            String playerRole = ksApi.getPlayerRole(player);
            UUID soulmateUuid = ksApi.getSoulmate(player);
            ServerPlayer soulmatePlayer = null;
            if (soulmateUuid != null) {
                soulmatePlayer = player.m_20194_().m_6846_().m_11259_(soulmateUuid);
            }
            if (GuardianRegenAbilityType.ID.equals((Object)abilityId) || WardRegenAbilityType.ID.equals((Object)abilityId)) {
                boolean isDeathCancelled;
                Optional regenDataOpt = RegenerationData.get((LivingEntity)player);
                if (regenDataOpt.isPresent() && (isDeathCancelled = ((RegenerationData)regenDataOpt.get()).stateManager().onKilled(event.getSource()))) {
                    ServerPlayer guardianPlayer;
                    ResourceLocation guardianAbilityId;
                    event.setCanceled(true);
                    if ("GUARDIAN".equals(playerRole) && GuardianRegenAbilityType.ID.equals((Object)abilityId)) {
                        int durationTicks = 7200;
                        int amplifier = 9;
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, durationTicks, amplifier, false, true));
                        player.m_213846_((Component)Component.m_237115_((String)"message.kindred_cycles.post_regen_buff"));
                    }
                    if ("WARD".equals(playerRole) && soulmatePlayer != null && GuardianRegenAbilityType.ID.equals((Object)(guardianAbilityId = ksApi.getPlayerAbilityType(guardianPlayer = soulmatePlayer)))) {
                        RegenerationData.get((LivingEntity)guardianPlayer).ifPresent(guardianRegenData -> {
                            if (guardianRegenData.canRegenerate() && guardianRegenData.regenState() == RegenStates.ALIVE) {
                                guardianRegenData.forceRegeneration();
                                guardianPlayer.m_213846_((Component)Component.m_237115_((String)"message.kindred_cycles.linked_regeneration"));
                            }
                        });
                    }
                }
                if (event.isCanceled()) {
                    return;
                }
            }
            if ("GUARDIAN".equals(playerRole) && soulmatePlayer != null) {
                RegenerationData.get((LivingEntity)soulmatePlayer).ifPresent(wardRegenData -> {
                    if (wardRegenData.regenState() != RegenStates.ALIVE) {
                        event.setCanceled(true);
                        player.m_21153_(10.0f);
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 1));
                        player.m_213846_((Component)Component.m_237115_((String)"message.kindred_cycles.ward_is_regenerating"));
                    }
                });
            }
        }
        catch (Exception e) {
            KindredCyclesMod.LOGGER.error("Error in Kindred Cycles death event handler", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
            try {
                RegenerationData.get((LivingEntity)player).ifPresent(regenData -> {
                    if (regenData.regenState() != RegenStates.ALIVE) {
                        regenData.tick();
                    }
                });
            }
            catch (Exception exception) {}
        }
    }
}

