/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredcycles.network;

import com.sapphic.kindredcycles.abilities.GuardianRegenAbilityType;
import com.sapphic.kindredsouls.api.IKindredSoulsAPI;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class C2S_HealWardPacket {
    private static final int HEAL_COOLDOWN_TICKS = 300;

    public C2S_HealWardPacket() {
    }

    public C2S_HealWardPacket(FriendlyByteBuf buf) {
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer guardian = ctx.getSender();
            if (guardian == null) {
                return;
            }
            if (guardian.m_36335_().m_41519_(guardian.m_21205_().m_41720_())) {
                guardian.m_240418_((Component)Component.m_237115_((String)"message.kindred_cycles.heal_cooldown"), true);
                return;
            }
            try {
                IKindredSoulsAPI ksApi = IKindredSoulsAPI.getInstance();
                if (!"GUARDIAN".equals(ksApi.getPlayerRole(guardian)) || !GuardianRegenAbilityType.ID.equals((Object)ksApi.getPlayerAbilityType(guardian))) {
                    guardian.m_240418_((Component)Component.m_237115_((String)"message.kindred_cycles.heal_fail_ability"), true);
                    return;
                }
                if (guardian.m_36324_().m_38702_() < 6) {
                    guardian.m_240418_((Component)Component.m_237115_((String)"message.kindred_cycles.heal_fail_hunger"), true);
                    return;
                }
                UUID soulmateUuid = ksApi.getSoulmate(guardian);
                if (soulmateUuid == null) {
                    return;
                }
                ServerPlayer ward = guardian.m_20194_().m_6846_().m_11259_(soulmateUuid);
                if (ward == null || ward.m_21224_()) {
                    guardian.m_240418_((Component)Component.m_237115_((String)"message.kindred_cycles.heal_fail_offline"), true);
                    return;
                }
                if (guardian.m_20280_((Entity)ward) > 1024.0) {
                    guardian.m_240418_((Component)Component.m_237115_((String)"message.kindred_cycles.heal_fail_distance"), true);
                    return;
                }
                guardian.m_36324_().m_38705_(guardian.m_36324_().m_38702_() - 6);
                guardian.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 0));
                guardian.m_36335_().m_41524_(guardian.m_21205_().m_41720_(), 300);
                ward.m_5634_(8.0f);
                ward.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 1));
                guardian.m_240418_((Component)Component.m_237110_((String)"message.kindred_cycles.heal_success_guardian", (Object[])new Object[]{ward.m_5446_()}), true);
                ward.m_240418_((Component)Component.m_237110_((String)"message.kindred_cycles.heal_success_ward", (Object[])new Object[]{guardian.m_5446_()}), true);
                guardian.m_9236_().m_5594_(null, guardian.m_20183_(), SoundEvents.f_144243_, SoundSource.PLAYERS, 1.0f, 0.8f);
                ward.m_9236_().m_5594_(null, ward.m_20183_(), SoundEvents.f_144243_, SoundSource.PLAYERS, 1.0f, 1.2f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return true;
    }
}

