/*
 * Decompiled with CFR 0.152.
 */
package vpp.vac.skyquill.module.impl.dungeons;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vpp.vac.skyquill.main.Main;
import vpp.vac.skyquill.module.Category;
import vpp.vac.skyquill.module.Module;
import vpp.vac.skyquill.util.Logger;

public class BloodRoomOpen
extends Module {
    private int count = 0;
    private boolean shouldRender;
    private FontRenderer fr;
    private int scale;
    private int X;
    private int Y;
    private ScaledResolution sr;
    private String text;
    private EntityPlayerSP player;

    public BloodRoomOpen() {
        this.fr = this.mc.field_71466_p;
        this.scale = 5;
        this.sr = new ScaledResolution(Minecraft.func_71410_x());
        this.text = "BLOOD OPEN";
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.name = "Blood Room Open Alert";
        this.description = "Displays an alert on your screen when blood room gets opened";
        this.moduleCategory = Category.DUNGEONS;
    }

    @Override
    public void onEnable() {
        this.toggled = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onDisable() {
        this.toggled = false;
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void onChatReceived(ClientChatReceivedEvent event) {
        if (this.toggled) {
            String[] lines;
            String message = event.message.func_150260_c();
            Logger log = new Logger();
            if (Main.DebugMode) {
                log.sendLog("Received message: " + message);
            }
            for (String line : lines = message.split("\n")) {
                if (!line.toLowerCase().contains("blood door") || !line.toLowerCase().contains("opened")) continue;
                this.player.func_71165_d("[SkyQuill] Blood Open!");
                this.shouldRender = true;
                if (!Main.DebugMode) continue;
                log.sendLog("Blood room open" + this.count);
                System.out.println("shouldRender boolean status: " + this.shouldRender);
            }
        }
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Text event) {
        if (!this.toggled || !this.shouldRender) {
            return;
        }
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int screenWidth = sr.func_78326_a();
        int screenHeight = sr.func_78328_b();
        int textWidth = fr.func_78256_a(this.text);
        int textHeight = fr.field_78288_b;
        int scaledTextWidth = Math.round(textWidth * this.scale);
        int scaledTextHeight = Math.round(textHeight * this.scale);
        int posX = (screenWidth - scaledTextWidth) / 2;
        int posY = (screenHeight - scaledTextHeight) / 2;
        if (this.count < 320) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
            fr.func_175063_a(this.text, (float)(posX / this.scale), (float)(posY / this.scale - 20), 12852754);
            GlStateManager.func_179121_F();
            ++this.count;
        } else {
            this.count = 0;
            this.shouldRender = false;
        }
    }
}

