/*
 * Decompiled with CFR 0.152.
 */
package vpp.vac.skyquill.module.impl.dungeons;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vpp.vac.skyquill.main.Main;
import vpp.vac.skyquill.module.Category;
import vpp.vac.skyquill.module.Module;
import vpp.vac.skyquill.util.FragType;

public class FragRunLootDetector
extends Module {
    private static int scale = 5;
    private String textHandle = "DIAMANTE HANDLE";
    private String textEye = "L.A.S.R EYE";
    private boolean shouldRender;
    private FragType frag;
    private int Tickcount;
    private int XHandle;
    private int XEye;
    private int Y;
    private FontRenderer fr;
    private ScaledResolution sr;

    public FragRunLootDetector() {
        this.fr = this.mc.field_71466_p;
        this.sr = new ScaledResolution(this.mc);
        this.name = "Frag run loot detector";
        this.moduleCategory = Category.DUNGEONS;
        this.description = "Sends a notification when you get a diamante handle or a LASR eye";
    }

    @Override
    public void onEnable() {
        this.toggled = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.updateScreenCoords();
    }

    @Override
    public void onDisable() {
        this.toggled = false;
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        String displayName;
        EntityPlayer player = event.entityPlayer;
        ItemStack stack = event.item.func_92059_d();
        if (stack.func_77973_b() == Items.field_151125_bZ && stack.func_82837_s()) {
            String displayName2 = stack.func_82833_r().toLowerCase();
            if (displayName2.contains("diamante's handle".toLowerCase())) {
                if (Main.DebugMode) {
                    System.out.println("Diamante's handle picked up");
                }
                this.frag = FragType.HANDLE;
                this.shouldRender = true;
                if (Main.DebugMode) {
                    System.out.println("FRAG DETECTOR STATUS: shouldRender: " + this.shouldRender + ", fragtype: " + (Object)((Object)this.frag));
                }
            }
        } else if (stack.func_77973_b() == Items.field_151061_bv && stack.func_82837_s() && (displayName = stack.func_82833_r().toLowerCase()).contains("l.a.s.r's eye".toLowerCase())) {
            if (Main.DebugMode) {
                System.out.println("L.A.S.R eye picked up");
            }
            this.frag = FragType.EYE;
            this.shouldRender = true;
            if (Main.DebugMode) {
                System.out.println("FRAG DETECTOR STATUS: shouldRender: " + this.shouldRender + ", fragtype: " + (Object)((Object)this.frag));
            }
        }
    }

    private void updateScreenCoords() {
        ScaledResolution sr = new ScaledResolution(this.mc);
        this.XHandle = sr.func_78326_a() / 2 - this.fr.func_78256_a(this.textHandle) * scale / 2;
        this.XEye = sr.func_78326_a() / 2 - this.fr.func_78256_a(this.textEye) * scale / 2;
        this.Y = 10;
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (this.mc.field_71439_g == null || this.mc.field_71441_e == null) {
            return;
        }
        if (!this.shouldRender) {
            return;
        }
        if (this.shouldRender) {
            if (this.Tickcount < 1200) {
                if (this.frag == FragType.EYE) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                    this.fr.func_175063_a(this.textEye, (float)(this.XEye / scale), (float)this.Y, 12852754);
                    GlStateManager.func_179121_F();
                    ++this.Tickcount;
                } else if (this.frag == FragType.HANDLE) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                    this.fr.func_175063_a(this.textHandle, (float)(this.XHandle / scale), (float)this.Y, 12852754);
                    GlStateManager.func_179121_F();
                    ++this.Tickcount;
                }
            } else {
                this.shouldRender = false;
                this.Tickcount = 0;
            }
        }
    }
}

