/*
 * Decompiled with CFR 0.152.
 */
package vpp.vac.skyquill.module.impl.misc;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vpp.vac.skyquill.main.Main;
import vpp.vac.skyquill.module.Category;
import vpp.vac.skyquill.module.Module;
import vpp.vac.skyquill.util.Logger;

public class BlackHoleReadyAlert
extends Module {
    private int count = 0;
    private boolean shouldRender;
    private FontRenderer fr;
    private int scale;
    private int X;
    private int Y;
    private ScaledResolution sr;
    private String text;
    private EntityPlayerSP player;
    private ArrayList<String> WatcherMessages;

    public BlackHoleReadyAlert() {
        this.fr = this.mc.field_71466_p;
        this.scale = 5;
        this.sr = new ScaledResolution(Minecraft.func_71410_x());
        this.text = "BLACK HOLE READY";
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.WatcherMessages = new ArrayList();
        this.name = "Black Hole Ready Alert";
        this.description = "Displays an alert on your screen when your black hole is ready to be deployed";
        this.moduleCategory = Category.HUNTING;
    }

    @Override
    public void onEnable() {
        this.toggled = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onDisable() {
        this.toggled = false;
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void onChatReceived(ClientChatReceivedEvent event) {
        if (this.toggled) {
            String[] lines;
            String message = event.message.func_150260_c();
            Logger log = new Logger();
            if (Main.DebugMode) {
                log.sendLog("Received message: " + message);
            }
            for (String line : lines = message.split("\n")) {
                if (!line.contains("You caught")) continue;
                this.shouldRender = true;
                if (!Main.DebugMode) continue;
                log.sendLog("Black hole is ready" + this.count);
                System.out.println("shouldRender boolean status: " + this.shouldRender);
            }
        }
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Text event) {
        if (!this.toggled || !this.shouldRender) {
            return;
        }
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int screenWidth = sr.func_78326_a();
        int screenHeight = sr.func_78328_b();
        int textWidth = fr.func_78256_a(this.text);
        int textHeight = fr.field_78288_b;
        int scaledTextWidth = Math.round(textWidth * this.scale);
        int scaledTextHeight = Math.round(textHeight * this.scale);
        int posX = (screenWidth - scaledTextWidth) / 2;
        int posY = (screenHeight - scaledTextHeight) / 2;
        if (this.count < 40) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
            fr.func_175063_a(this.text, (float)(posX / this.scale), (float)(posY / this.scale - 5), 1236525);
            GlStateManager.func_179121_F();
            ++this.count;
        } else {
            this.count = 0;
            this.shouldRender = false;
        }
    }
}

