/*
 * Decompiled with CFR 0.152.
 */
package net.timeworndevs.curieapi;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.timeworndevs.curieapi.event.PlayerTickHandler;
import net.timeworndevs.curieapi.radiation.RadiationType;
import net.timeworndevs.curieapi.util.CurieAPIConfig;
import net.timeworndevs.curieapi.util.PlayerCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurieAPI
implements ModInitializer {
    public static final String MOD_ID = "curie-api";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"curie-api");
    public static WeakHashMap<UUID, PlayerCache> CACHE;
    public static List<RadiationType> LOADED_TYPES;

    public void onInitialize() {
        LOGGER.info("Computing wave-functions...");
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            LOGGER.info("reading config...");
            CurieAPIConfig.readConfig();
            LOADED_TYPES = new ArrayList<RadiationType>(CurieAPIConfig.RADIATION_TYPES.values());
            CACHE = new WeakHashMap();
        });
        ServerTickEvents.START_SERVER_TICK.register((Object)new PlayerTickHandler());
        LOGGER.info("Wormhole established!");
    }
}

