/*
 * Decompiled with CFR 0.152.
 */
package net.timeworndevs.curieapi.radiation;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.timeworndevs.curieapi.CurieAPI;
import net.timeworndevs.curieapi.radiation.RadiationEntry;
import net.timeworndevs.curieapi.radiation.RadiationType;
import net.timeworndevs.curieapi.util.ArmorInsulator;
import net.timeworndevs.curieapi.util.CurieAPIConfig;
import net.timeworndevs.curieapi.util.PlayerCache;

public class RadiationCalculator {
    public static float calculateInventoryRadiation(RadiationType type, PlayerCache cache) {
        RadiationEntry entry = RadiationEntry.createEmpty();
        Map<class_1792, Integer> items = cache.createInventoryMap();
        if (cache.inventoryEquals(items)) {
            entry = cache.getPrevItemRadiation();
        } else {
            for (Map.Entry<class_1792, Integer> itemEntry : items.entrySet()) {
                class_1792 item = itemEntry.getKey();
                RadiationEntry radiationEntry = CurieAPIConfig.ITEM_RADIATION_VALUES.get(item);
                if (radiationEntry == null) continue;
                RadiationEntry finalEntry = entry;
                radiationEntry.entries().forEach((radiationType, value) -> finalEntry.add((RadiationType)radiationType, value.floatValue() * (float)((Integer)itemEntry.getValue()).intValue()));
            }
            cache.setItemRadiation(entry);
            cache.updateInventory();
        }
        return Math.min(entry.get(type), (float)CurieAPIConfig.MAX_ITEM_INTAKE);
    }

    public static float calculateBiomeRadiation(class_3218 world, class_3222 player, RadiationType type, PlayerCache cache) {
        float biomeMultiplier = 0.0f;
        Optional biome = world.method_23753(player.method_24515()).method_40230();
        if (biome.isPresent()) {
            String biomeID = ((class_5321)biome.get()).method_29177().toString();
            if (CurieAPIConfig.BIOME_RADIATION_VALUES.containsKey(biomeID)) {
                biomeMultiplier = CurieAPIConfig.BIOME_RADIATION_VALUES.get(biomeID).get(type);
                cache.setBiomeRadiation(type, biomeMultiplier);
            }
            if (world.method_27983().equals(class_1937.field_25179)) {
                biomeMultiplier *= (float)world.method_8314(class_1944.field_9284, player.method_24515()) / 15.0f;
            }
        }
        return biomeMultiplier;
    }

    private static class_3965 raycastInsulator(class_3959 context, Predicate<class_2680> statePredicate, class_2338 ignored, class_3218 world) {
        return (class_3965)class_1922.method_17744((class_243)context.method_17750(), (class_243)context.method_17747(), (Object)context, (innerContext, pos) -> {
            if (pos.equals((Object)ignored)) {
                return null;
            }
            class_243 start = innerContext.method_17750();
            class_243 end = innerContext.method_17747();
            class_2680 blockState = world.method_8320(pos);
            if (!statePredicate.test(blockState)) {
                return null;
            }
            class_265 voxelShape = innerContext.method_17748(blockState, (class_1922)world, pos);
            return world.method_17745(start, end, pos, voxelShape, blockState);
        }, innerContext -> {
            class_243 vec3d = innerContext.method_17750().method_1020(innerContext.method_17747());
            return class_3965.method_17778((class_243)innerContext.method_17747(), (class_2350)class_2350.method_10142((double)vec3d.field_1352, (double)vec3d.field_1351, (double)vec3d.field_1350), (class_2338)class_2338.method_49638((class_2374)innerContext.method_17747()));
        });
    }

    public static float calculateInsulators(class_3218 world, class_3222 player, RadiationType type, class_2338 blockPos) {
        class_3965 result;
        float totalInsulation = 0.0f;
        class_243 start = player.method_19538().method_1031(0.0, 0.1, 0.0);
        class_243 end = blockPos.method_46558();
        class_2338 lastBlockPos = null;
        while (!(lastBlockPos = (result = RadiationCalculator.raycastInsulator(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player), blockState -> CurieAPIConfig.INSULATORS.containsKey(blockState.method_26204()) && CurieAPIConfig.INSULATORS.get(blockState.method_26204()).containsKey(type), lastBlockPos, world)).method_17777()).equals((Object)blockPos)) {
            RadiationEntry entry = CurieAPIConfig.INSULATORS.get(world.method_8320(lastBlockPos).method_26204());
            if (entry != null) {
                totalInsulation += entry.get(type);
            }
            start = result.method_17784();
        }
        return totalInsulation;
    }

    public static float calculateBlockRadiation(class_3218 world, class_3222 player, RadiationType type, PlayerCache cache) {
        float radiation = 0.0f;
        class_2338 corner1 = player.method_24515().method_10069(-5, -5, -5);
        class_2338 corner2 = player.method_24515().method_10069(5, 5, 5);
        for (class_2338 pos : class_2338.method_10097((class_2338)corner1, (class_2338)corner2)) {
            class_2248 block = world.method_8320(pos).method_26204();
            if (block.equals(class_2246.field_10124) || !CurieAPIConfig.BLOCK_RADIATION_VALUES.containsKey(block)) continue;
            float insulatorValue = RadiationCalculator.calculateInsulators(world, player, type, pos);
            radiation += Math.max(0.0f, CurieAPIConfig.BLOCK_RADIATION_VALUES.get(block).get(type) - insulatorValue);
        }
        radiation = Math.min(radiation, (float)CurieAPIConfig.MAX_ITEM_INTAKE);
        cache.setBlockRadiation(type, radiation);
        return radiation;
    }

    public static int calculateRadiationForType(class_3218 world, class_3222 player, RadiationType type, PlayerCache cache) {
        float biomeMultiplier = RadiationCalculator.calculateBiomeRadiation(world, player, type, cache);
        float radiationAround = RadiationCalculator.calculateBlockRadiation(world, player, type, cache);
        float radiationFromItems = RadiationCalculator.calculateInventoryRadiation(type, cache);
        float armorProtection = 0.0f;
        List<class_1792> armor = cache.createArmorMap();
        if (!cache.armorEquals(armor)) {
            RadiationEntry entry = RadiationEntry.createEmpty();
            for (class_1792 item : armor) {
                ArmorInsulator insulator = ArmorInsulator.findSetForItem(item);
                if (insulator == null) continue;
                insulator.radiations().entries().forEach((radiationType, value) -> entry.add((RadiationType)radiationType, value.floatValue() * insulator.getMultiplier(item) * 100.0f));
            }
            cache.updateArmor(armor, entry);
        }
        armorProtection = cache.getArmorInsulation().get(type);
        int formula = Math.round((radiationAround + radiationFromItems + biomeMultiplier) * (100.0f - Math.min(armorProtection, 100.0f)) / (float)CurieAPIConfig.DIV_CONSTANT);
        CurieAPI.LOGGER.info("Formula: {}", (Object)formula);
        return formula;
    }
}

