/*
 * Decompiled with CFR 0.152.
 */
package net.timeworndevs.curieapi.radiation;

import java.util.HashMap;
import java.util.Map;
import net.timeworndevs.curieapi.radiation.RadiationType;

public record RadiationEntry(Map<RadiationType, Float> entries) {
    public static RadiationEntry createEmpty() {
        return new RadiationEntry(new HashMap<RadiationType, Float>());
    }

    public float get(RadiationType type) {
        return this.entries.getOrDefault(type, Float.valueOf(0.0f)).floatValue();
    }

    public void clear() {
        this.entries.clear();
    }

    public void add(RadiationType type, float value) {
        this.put(type, this.get(type) + value);
    }

    public float addAllTypes() {
        return this.entries.values().stream().reduce(Float.valueOf(0.0f), Float::sum).floatValue();
    }

    public void put(RadiationType type, float value) {
        this.entries.put(type, Float.valueOf(value));
    }

    @Override
    public String toString() {
        return "RadiationEntry{entries=" + String.valueOf(this.entries) + "}";
    }

    public boolean containsKey(RadiationType type) {
        return this.entries.containsKey(type);
    }
}

