/*
 * Decompiled with CFR 0.152.
 */
package net.timeworndevs.curieapi.radiation;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.timeworndevs.curieapi.radiation.RadiationNBT;
import net.timeworndevs.curieapi.util.CurieAPIConfig;
import net.timeworndevs.curieapi.util.IEntityDataSaver;

public class RadiationType {
    private final String name;
    private final List<Float> color;
    private final class_2960 syncID;
    private final RadiationPacket syncPacket;

    public RadiationType(String name, List<Float> color) {
        this.name = name;
        this.color = color;
        this.syncID = new class_2960("curie-api", "radiation_" + name + "_sync");
        this.syncPacket = new RadiationPacket(this, this.syncID);
    }

    public static RadiationType getRadiationType(String name) {
        return CurieAPIConfig.RADIATION_TYPES.get(name);
    }

    public List<Float> getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public class_2960 getSyncID() {
        return this.syncID;
    }

    public RadiationPacket getSyncPacket() {
        return this.syncPacket;
    }

    public static RadiationType register(String name, List<Float> color) {
        RadiationType type = new RadiationType(name, color);
        CurieAPIConfig.RADIATION_TYPES.putIfAbsent(name, type);
        return type;
    }

    public static class RadiationPacket {
        public static ArrayList<RadiationPacket> PACKETS = new ArrayList();
        private final RadiationType radiationType;
        private final class_2960 id;

        public RadiationPacket(RadiationType type, class_2960 id) {
            this.radiationType = type;
            this.id = id;
            PACKETS.add(this);
        }

        public static void registerPackets() {
            for (RadiationPacket packet : PACKETS) {
                packet.registerPacket();
            }
        }

        private void registerPacket() {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)this.id, this::receive);
        }

        public void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
            int value = buf.readInt();
            if (client.field_1724 != null) {
                RadiationNBT.set((IEntityDataSaver)client.field_1724, this.radiationType, Math.min(value, CurieAPIConfig.CAP));
            }
        }
    }
}

