/*
 * Decompiled with CFR 0.152.
 */
package net.timeworndevs.curieapi.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.timeworndevs.curieapi.CurieAPI;
import net.timeworndevs.curieapi.radiation.RadiationEntry;
import net.timeworndevs.curieapi.radiation.RadiationType;
import net.timeworndevs.curieapi.util.ArmorInsulator;

public class CurieAPIConfig {
    public static LinkedHashMap<String, RadiationType> RADIATION_TYPES = new LinkedHashMap();
    public static Map<class_2248, RadiationEntry> BLOCK_RADIATION_VALUES = new HashMap<class_2248, RadiationEntry>();
    public static Map<class_1792, RadiationEntry> ITEM_RADIATION_VALUES = new HashMap<class_1792, RadiationEntry>();
    public static Map<String, RadiationEntry> BIOME_RADIATION_VALUES = new HashMap<String, RadiationEntry>();
    public static Map<class_2248, RadiationEntry> INSULATORS = new HashMap<class_2248, RadiationEntry>();
    public static ArrayList<ArmorInsulator> ARMOR_INSULATORS = new ArrayList();
    private static final int defaultCap = 100000;
    private static final int defaultDivConstant = 4;
    private static final int defaultMaxItemIntake = 100;
    private static final int defaultMaxBlockIntake = 100;
    private static final int[] defaultPassiveDecay = new int[]{1, 8};
    public static int CAP = 100000;
    public static int DIV_CONSTANT = 4;
    public static int MAX_ITEM_INTAKE = 100;
    public static int MAX_BLOCK_INTAKE = 100;
    public static int[] PASSIVE_DECAY = defaultPassiveDecay;
    private static final Map<String, Consumer<JsonElement>> configHandlers = Map.of("radiation_types", CurieAPIConfig::addRadiationTypes, "blocks", CurieAPIConfig::addBlocksToConfig, "biomes", CurieAPIConfig::addBiomesToConfig, "items", CurieAPIConfig::addItemsToConfig, "insulators", CurieAPIConfig::addInsulatorsToConfig, "armor", CurieAPIConfig::addArmorInsulatorsToConfig);

    public static void readConfig() {
        Path path = Paths.get(String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/curie", new String[0]);
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectory(path, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            CurieAPI.LOGGER.error("Couldn't create directory: {}", (Object)path);
        }
        try (Stream<Path> stream = Files.list(path);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).forEach(file -> {
                try (BufferedReader br = new BufferedReader(new FileReader((File)file));){
                    JsonObject json = JsonParser.parseReader((Reader)br).getAsJsonObject();
                    for (Map.Entry<String, Consumer<JsonElement>> entry : configHandlers.entrySet()) {
                        if (!json.has(entry.getKey())) continue;
                        CurieAPI.LOGGER.info("Loaded config: {}", (Object)entry.getKey());
                        entry.getValue().accept(json.get(entry.getKey()));
                    }
                    if (json.has("cap") && CAP == 100000) {
                        CAP = json.get("cap").getAsInt();
                    }
                    if (json.has("div_constant") && DIV_CONSTANT == 4) {
                        DIV_CONSTANT = json.get("div_constant").getAsInt();
                    }
                    if (json.has("max_block_intake") && MAX_BLOCK_INTAKE == 100) {
                        MAX_BLOCK_INTAKE = json.get("max_block_intake").getAsInt();
                    }
                    if (json.has("max_item_intake") && MAX_ITEM_INTAKE == 100) {
                        MAX_ITEM_INTAKE = json.get("max_item_intake").getAsInt();
                    }
                    if (json.has("passive_radiation_decay") && PASSIVE_DECAY == defaultPassiveDecay) {
                        JsonArray array = json.getAsJsonArray("passive_radiation_decay");
                        PASSIVE_DECAY = new int[]{array.get(0).getAsInt(), array.get(1).getAsInt()};
                    }
                }
                catch (IOException e) {
                    CurieAPI.LOGGER.error("Couldn't read file: {}", (Object)path);
                }
            });
        }
        catch (IOException e) {
            CurieAPI.LOGGER.error("Couldn't read file: {}", (Object)path);
        }
    }

    private static void addRadiationTypes(JsonElement json) {
        for (JsonElement element : json.getAsJsonArray()) {
            JsonObject object = element.getAsJsonObject();
            String name = object.get("name").getAsString();
            RADIATION_TYPES.computeIfAbsent(name, radiationType -> {
                JsonArray array = object.getAsJsonArray("color");
                ArrayList<Float> color = new ArrayList<Float>();
                for (int i = 0; i < Math.min(array.size(), 4); ++i) {
                    color.add(i, Float.valueOf(array.get(i).getAsFloat()));
                }
                return new RadiationType(name, color);
            });
        }
    }

    private static void addBlocksToConfig(JsonElement json) {
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            JsonObject object = ((JsonElement)entry.getValue()).getAsJsonObject();
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960((String)entry.getKey()));
            if (block == class_2246.field_10124) continue;
            BLOCK_RADIATION_VALUES.computeIfAbsent(block, data -> CurieAPIConfig.mapRadiationTypes(object));
        }
    }

    private static void addInsulatorsToConfig(JsonElement json) {
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            JsonObject object = ((JsonElement)entry.getValue()).getAsJsonObject();
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960((String)entry.getKey()));
            if (block == class_2246.field_10124) continue;
            INSULATORS.computeIfAbsent(block, data -> CurieAPIConfig.mapRadiationTypes(object));
        }
    }

    private static void addBiomesToConfig(JsonElement json) {
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            JsonObject object = ((JsonElement)entry.getValue()).getAsJsonObject();
            BIOME_RADIATION_VALUES.computeIfAbsent((String)entry.getKey(), data -> CurieAPIConfig.mapRadiationTypes(object));
        }
    }

    private static void addItemsToConfig(JsonElement json) {
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            JsonObject object = ((JsonElement)entry.getValue()).getAsJsonObject();
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960((String)entry.getKey()));
            if (item == class_1802.field_8162) continue;
            ITEM_RADIATION_VALUES.computeIfAbsent(item, data -> CurieAPIConfig.mapRadiationTypes(object));
        }
    }

    private static void addArmorInsulatorsToConfig(JsonElement json) {
        for (JsonElement element : json.getAsJsonArray()) {
            HashMap<class_1792, Float> armorValues = new HashMap<class_1792, Float>();
            JsonObject object = element.getAsJsonObject();
            if (!object.has("armor") || !object.has("radiation")) continue;
            for (Map.Entry entry : object.getAsJsonObject("armor").entrySet()) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960((String)entry.getKey()));
                if (item == class_1802.field_8162) continue;
                armorValues.put(item, Float.valueOf(((JsonElement)entry.getValue()).getAsFloat()));
            }
            if (armorValues.isEmpty()) continue;
            RadiationEntry entry = CurieAPIConfig.mapRadiationTypes(object.getAsJsonObject("radiation"));
            ArmorInsulator.register(armorValues, entry);
        }
    }

    private static RadiationEntry mapRadiationTypes(JsonObject json) {
        return new RadiationEntry(json.keySet().stream().filter(type -> RadiationType.getRadiationType(type) != null).map(key -> Map.entry(RadiationType.getRadiationType(key), Float.valueOf(json.get(key).getAsFloat()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }
}

