/*
 * Decompiled with CFR 0.152.
 */
package net.timeworndevs.curieapi.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.timeworndevs.curieapi.CurieAPI;
import net.timeworndevs.curieapi.radiation.RadiationEntry;
import net.timeworndevs.curieapi.radiation.RadiationType;

public class PlayerCache {
    private final class_1657 player;
    private Map<class_1792, Integer> inventory = new HashMap<class_1792, Integer>();
    private List<class_1792> armor;
    private RadiationEntry itemRadiation = RadiationEntry.createEmpty();
    private final RadiationEntry biomeRadiation = RadiationEntry.createEmpty();
    private final RadiationEntry blockRadiation = RadiationEntry.createEmpty();
    private RadiationEntry armorInsulation = RadiationEntry.createEmpty();

    public PlayerCache(class_1657 player) {
        this.player = player;
        this.armor = this.createArmorMap();
    }

    public static PlayerCache get(class_1657 player) {
        UUID uuid = player.method_5667();
        if (!CurieAPI.CACHE.containsKey(uuid)) {
            CurieAPI.CACHE.put(uuid, new PlayerCache(player));
        }
        return CurieAPI.CACHE.get(uuid);
    }

    public static void add(class_1657 player) {
        CurieAPI.CACHE.putIfAbsent(player.method_5667(), new PlayerCache(player));
    }

    public boolean inventoryEquals(Map<class_1792, Integer> other) {
        return this.inventory.equals(other);
    }

    public Map<class_1792, Integer> createInventoryMap() {
        return this.player.method_31548().field_7547.stream().filter(stack -> !stack.method_7960()).collect(Collectors.groupingBy(class_1799::method_7909, Collectors.summingInt(class_1799::method_7947)));
    }

    public void updateInventory() {
        this.inventory = this.createInventoryMap();
    }

    public void setItemRadiation(RadiationEntry entry) {
        this.itemRadiation = entry;
    }

    public RadiationEntry getPrevItemRadiation() {
        return this.itemRadiation;
    }

    public boolean armorEquals(List<class_1792> armor) {
        return this.armor.equals(armor);
    }

    public List<class_1792> createArmorMap() {
        return this.player.method_31548().field_7548.stream().filter(stack -> !stack.method_7960()).map(class_1799::method_7909).toList();
    }

    public void updateArmor(List<class_1792> armor, RadiationEntry entry) {
        this.armor = armor;
        this.armorInsulation = entry;
    }

    public RadiationEntry getArmorInsulation() {
        return this.armorInsulation;
    }

    public RadiationEntry getPrevBiomeRadiation() {
        return this.biomeRadiation;
    }

    public void setBiomeRadiation(RadiationType type, float radiation) {
        this.biomeRadiation.put(type, radiation);
    }

    public RadiationEntry getPrevBlockRadiation() {
        return this.blockRadiation;
    }

    public void setBlockRadiation(RadiationType type, float radiation) {
        this.blockRadiation.put(type, radiation);
    }
}

