/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xheadturns.animation.types;

import java.util.Map;
import jn.willfrydev.xheadturns.animation.Animation;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ItemDisplay;

public class HelixAnimation
implements Animation {
    @Override
    public void play(ItemDisplay display, ConfigurationSection config, Map<String, Object> state) {
        double angle = (Double)state.getOrDefault("angle", 0.0);
        double y = (Double)state.getOrDefault("y", 0.0);
        Location center = display.getLocation();
        double radius = config.getDouble("size", 1.0);
        Particle particle = this.getParticle(config.getString("particle", "REDSTONE"));
        Object particleData = this.getParticleData(particle, config.getString("color"));
        double x = radius * Math.cos(angle);
        double z = radius * Math.sin(angle);
        center.getWorld().spawnParticle(particle, center.clone().add(x, y, z), 0, 0.0, 0.0, 0.0, 0.0, particleData, true);
        center.getWorld().spawnParticle(particle, center.clone().add(-x, y, -z), 0, 0.0, 0.0, 0.0, 0.0, particleData, true);
        state.put("angle", angle + 0.19634954084936207);
        state.put("y", y > (double)display.getTransformation().getScale().y() * 1.5 ? 0.0 : y + 0.1);
    }

    private Particle getParticle(String name) {
        try {
            return Particle.valueOf((String)name.toUpperCase());
        }
        catch (Exception e) {
            return Particle.REDSTONE;
        }
    }

    private Object getParticleData(Particle particle, String colorString) {
        String[] rgb;
        if (particle == Particle.REDSTONE && colorString != null && (rgb = colorString.split(",")).length == 3) {
            return new Particle.DustOptions(Color.fromRGB((int)Integer.parseInt(rgb[0].trim()), (int)Integer.parseInt(rgb[1].trim()), (int)Integer.parseInt(rgb[2].trim())), 1.0f);
        }
        return null;
    }
}

