/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xheadturns.animation.types;

import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import jn.willfrydev.xheadturns.animation.Animation;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ItemDisplay;

public class SphereAnimation
implements Animation {
    @Override
    public void play(ItemDisplay display, ConfigurationSection config, Map<String, Object> state) {
        Location center = display.getLocation().clone().add(0.0, (double)(display.getTransformation().getScale().y() / 2.0f), 0.0);
        double radius = config.getDouble("size", 1.0);
        int particleCount = config.getInt("particle-count", 15);
        Particle particle = this.getParticle(config.getString("particle", "REDSTONE"));
        Object particleData = this.getParticleData(particle, config.getString("color"));
        for (int i = 0; i < particleCount; ++i) {
            double u = ThreadLocalRandom.current().nextDouble();
            double v = ThreadLocalRandom.current().nextDouble();
            double theta = Math.PI * 2 * u;
            double phi = Math.acos(2.0 * v - 1.0);
            double x = radius * Math.sin(phi) * Math.cos(theta);
            double y = radius * Math.sin(phi) * Math.sin(theta);
            double z = radius * Math.cos(phi);
            center.add(x, y, z);
            center.getWorld().spawnParticle(particle, center, 0, 0.0, 0.0, 0.0, 0.0, particleData, true);
            center.subtract(x, y, z);
        }
    }

    private Particle getParticle(String name) {
        try {
            return Particle.valueOf((String)name.toUpperCase());
        }
        catch (Exception e) {
            return Particle.REDSTONE;
        }
    }

    private Object getParticleData(Particle particle, String colorString) {
        String[] rgb;
        if (particle == Particle.REDSTONE && colorString != null && (rgb = colorString.split(",")).length == 3) {
            return new Particle.DustOptions(Color.fromRGB((int)Integer.parseInt(rgb[0].trim()), (int)Integer.parseInt(rgb[1].trim()), (int)Integer.parseInt(rgb[2].trim())), 1.0f);
        }
        return null;
    }
}

