/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xheadturns.api;

import java.util.Optional;
import java.util.Set;
import jn.willfrydev.xheadturns.manager.HeadManager;
import jn.willfrydev.xheadturns.object.FloatingHead;
import org.bukkit.Location;
import org.bukkit.entity.ItemDisplay;
import org.jetbrains.annotations.NotNull;

public class xHeadTurnsAPI {
    private final HeadManager headManager;

    public xHeadTurnsAPI(HeadManager headManager) {
        this.headManager = headManager;
    }

    public boolean headExists(@NotNull String name) {
        return this.headManager.getHeadNames().stream().anyMatch(headName -> headName.equalsIgnoreCase(name));
    }

    public Set<String> getHeadNames() {
        return this.headManager.getHeadNames();
    }

    public Optional<Location> getHeadLocation(@NotNull String name) {
        FloatingHead head = this.getFloatingHead(name);
        return head != null ? Optional.ofNullable(head.getLocation()) : Optional.empty();
    }

    public Optional<ItemDisplay> getHeadEntity(@NotNull String name) {
        FloatingHead head = this.getFloatingHead(name);
        return head != null ? Optional.ofNullable(head.getItemDisplay()) : Optional.empty();
    }

    private FloatingHead getFloatingHead(String name) {
        return this.headManager.getActiveHeads().get(name.toLowerCase());
    }
}

