/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xheadturns.gui;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import jn.willfrydev.xheadturns.xHeadTurns;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class HeadListGUI
implements Listener {
    private final xHeadTurns plugin;
    private Inventory gui;

    public HeadListGUI(xHeadTurns plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void open(Player player) {
        Set<String> headNames = this.plugin.getHeadManager().getHeadNames();
        int size = (int)(Math.ceil((double)headNames.size() / 9.0) * 9.0);
        if (size == 0) {
            size = 9;
        }
        TextComponent title = LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getConfigManager().getMessage("gui-title"));
        this.gui = Bukkit.createInventory(null, (int)size, (Component)title);
        for (String headName : headNames) {
            ItemStack item = new ItemStack(Material.PLAYER_HEAD);
            ItemMeta meta = item.getItemMeta();
            if (meta == null) continue;
            meta.displayName(Component.text((String)("\u00a7a" + headName)).decoration(TextDecoration.ITALIC, false));
            ArrayList<Object> lore = new ArrayList<Object>();
            Location loc = this.plugin.getConfigManager().getLocation("heads." + headName);
            if (loc != null) {
                lore.add(Component.text((String)String.format("\u00a77Mundo: \u00a7f%s", loc.getWorld().getName())).decoration(TextDecoration.ITALIC, false));
                lore.add(Component.text((String)String.format("\u00a77Coords: \u00a7f%.1f, %.1f, %.1f", loc.getX(), loc.getY(), loc.getZ())).decoration(TextDecoration.ITALIC, false));
            }
            lore.add(Component.text((String)" "));
            lore.add(Component.text((String)"\u00a7eClic Izquierdo \u00a77para TP").decoration(TextDecoration.ITALIC, false));
            lore.add(Component.text((String)"\u00a7cClic Derecho \u00a77para Eliminar").decoration(TextDecoration.ITALIC, false));
            meta.lore(lore);
            item.setItemMeta(meta);
            this.gui.addItem(new ItemStack[]{item});
        }
        player.openInventory(this.gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory() != this.gui) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() != Material.PLAYER_HEAD) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String headName = LegacyComponentSerializer.legacySection().serialize(clickedItem.getItemMeta().displayName()).substring(2);
        if (event.isLeftClick()) {
            Location loc = this.plugin.getConfigManager().getLocation("heads." + headName);
            if (loc != null) {
                player.teleport(loc);
                this.plugin.getConfigManager().sendMessage((CommandSender)player, "gui-teleport-success", Map.of("{name}", headName));
                player.closeInventory();
            }
        } else if (event.isRightClick()) {
            player.performCommand("xhtd " + headName);
            player.closeInventory();
        }
    }
}

