/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xheadturns.manager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jn.willfrydev.xheadturns.xHeadTurns;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final xHeadTurns plugin;
    private FileConfiguration dataConfig;
    private File configFile;
    private FileConfiguration messagesConfig;
    private FileConfiguration presetsConfig;
    private File presetsFile;

    public ConfigManager(xHeadTurns plugin) {
        this.plugin = plugin;
        this.saveDefaultConfig();
        this.loadMessages();
        this.loadPresets();
    }

    public void reloadConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.loadMessages();
        this.loadPresets();
    }

    public FileConfiguration getConfig() {
        if (this.dataConfig == null) {
            this.reloadConfig();
        }
        return this.dataConfig;
    }

    public void saveConfig() {
        try {
            if (this.configFile == null) {
                this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
            }
            this.getConfig().save(this.configFile);
        }
        catch (IOException ex) {
            this.plugin.getLogger().severe("Could not save config to " + String.valueOf(this.configFile));
        }
    }

    public void saveDefaultConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        }
        if (!this.configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
    }

    public void loadPresets() {
        this.presetsFile = new File(this.plugin.getDataFolder(), "presets.yml");
        if (!this.presetsFile.exists()) {
            this.plugin.saveResource("presets.yml", false);
        }
        this.presetsConfig = YamlConfiguration.loadConfiguration((File)this.presetsFile);
    }

    public ConfigurationSection getPreset(String name) {
        return this.presetsConfig.getConfigurationSection("presets." + name);
    }

    public Set<String> getPresetNames() {
        ConfigurationSection section = this.presetsConfig.getConfigurationSection("presets");
        return section != null ? section.getKeys(false) : Collections.emptySet();
    }

    public Location getLocation(String path) {
        World world;
        String worldName = this.getConfig().getString(path + ".location.world");
        World world2 = world = worldName != null ? Bukkit.getWorld((String)worldName) : null;
        if (world == null) {
            return null;
        }
        return new Location(world, this.getConfig().getDouble(path + ".location.x"), this.getConfig().getDouble(path + ".location.y"), this.getConfig().getDouble(path + ".location.z"));
    }

    public void sendMessage(CommandSender sender, String key, Map<String, String> placeholders) {
        String message = this.messagesConfig.getString(key, "&cMessage not found: " + key);
        String prefix = this.messagesConfig.getString("prefix", "");
        message = message.replace("{prefix}", prefix);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace(entry.getKey(), entry.getValue());
        }
        TextComponent component = LegacyComponentSerializer.legacyAmpersand().deserialize(message);
        sender.sendMessage((Component)component);
    }

    public String getMessage(String key) {
        return this.messagesConfig.getString(key, "Message not found: " + key);
    }

    public void sendHelpMessage(CommandSender sender) {
        List lines = this.messagesConfig.getStringList("help-message");
        for (String line : lines) {
            sender.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(line));
        }
    }

    public void loadMessages() {
        String lang = this.getConfig().getString("locale", "en");
        File messagesFile = new File(this.plugin.getDataFolder(), "messages/" + lang + ".yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages/" + lang + ".yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
        try (InputStream defaultStream = this.plugin.getResource("messages/" + lang + ".yml");){
            if (defaultStream != null) {
                this.messagesConfig.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream, StandardCharsets.UTF_8)));
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not load messages for locale: " + lang);
        }
    }
}

