/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xheadturns.manager;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import jn.willfrydev.xheadturns.object.FloatingHead;
import jn.willfrydev.xheadturns.xHeadTurns;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;

public class HeadManager
implements Listener {
    private final xHeadTurns plugin;
    private final Map<String, FloatingHead> activeHeads = new HashMap<String, FloatingHead>();

    public HeadManager(xHeadTurns plugin) {
        this.plugin = plugin;
    }

    public void spawnAllHeads() {
        ConfigurationSection headsSection = this.plugin.getConfigManager().getConfig().getConfigurationSection("heads");
        if (headsSection == null) {
            return;
        }
        for (String headName : headsSection.getKeys(false)) {
            FloatingHead head = new FloatingHead(this.plugin, headName);
            head.spawn();
            this.activeHeads.put(headName.toLowerCase(), head);
        }
        this.plugin.getLogger().info(this.activeHeads.size() + " floating heads have been spawned.");
    }

    public void reloadAllHeads() {
        this.removeAllHeads();
        this.spawnAllHeads();
    }

    public void removeAllHeads() {
        this.activeHeads.values().forEach(FloatingHead::remove);
        this.activeHeads.clear();
    }

    public void createHead(Player player, String name, String presetName) {
        if (this.activeHeads.containsKey(name.toLowerCase())) {
            this.plugin.getConfigManager().sendMessage((CommandSender)player, "create-fail-exists", Map.of("{name}", name));
            return;
        }
        ConfigurationSection preset = this.plugin.getConfigManager().getPreset(presetName);
        if (preset == null) {
            this.plugin.getConfigManager().sendMessage((CommandSender)player, "preset-not-found", Map.of("{preset}", presetName));
            return;
        }
        Location location = player.getEyeLocation();
        String path = "heads." + name;
        for (String key : preset.getKeys(true)) {
            this.plugin.getConfigManager().getConfig().set(path + "." + key, preset.get(key));
        }
        this.plugin.getConfigManager().getConfig().set(path + ".location.world", (Object)location.getWorld().getName());
        this.plugin.getConfigManager().getConfig().set(path + ".location.x", (Object)location.getX());
        this.plugin.getConfigManager().getConfig().set(path + ".location.y", (Object)location.getY());
        this.plugin.getConfigManager().getConfig().set(path + ".location.z", (Object)location.getZ());
        this.plugin.getConfigManager().saveConfig();
        FloatingHead newHead = new FloatingHead(this.plugin, name);
        newHead.spawn();
        this.activeHeads.put(name.toLowerCase(), newHead);
        this.plugin.getConfigManager().sendMessage((CommandSender)player, "create-success-preset", Map.of("{name}", name, "{preset}", presetName));
    }

    public void deleteHead(String name, CommandSender sender) {
        String lowerName = name.toLowerCase();
        if (!this.activeHeads.containsKey(lowerName)) {
            this.plugin.getConfigManager().sendMessage(sender, "head-not-found", Map.of("{name}", name));
            return;
        }
        FloatingHead head = this.activeHeads.remove(lowerName);
        if (head != null) {
            head.remove();
        }
        this.plugin.getConfigManager().getConfig().set("heads." + name, null);
        this.plugin.getConfigManager().saveConfig();
        this.plugin.getConfigManager().sendMessage(sender, "delete-success", Map.of("{name}", name));
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (!(event.getRightClicked() instanceof Interaction)) {
            return;
        }
        UUID clickedUUID = event.getRightClicked().getUniqueId();
        for (FloatingHead head : this.activeHeads.values()) {
            if (head.getInteractionUUID() == null || !head.getInteractionUUID().equals(clickedUUID)) continue;
            head.handleClick(event.getPlayer());
            event.setCancelled(true);
            break;
        }
    }

    public Set<String> getHeadNames() {
        ConfigurationSection headsSection = this.plugin.getConfigManager().getConfig().getConfigurationSection("heads");
        return headsSection != null ? headsSection.getKeys(false) : Collections.emptySet();
    }

    public Map<String, FloatingHead> getActiveHeads() {
        return this.activeHeads;
    }
}

