/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xheadturns.object;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import jn.willfrydev.xheadturns.animation.Animation;
import jn.willfrydev.xheadturns.animation.AnimationType;
import jn.willfrydev.xheadturns.xHeadTurns;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Transformation;
import org.joml.AxisAngle4f;

public class FloatingHead {
    private final xHeadTurns plugin;
    private final String name;
    private ItemDisplay itemDisplay;
    private Interaction interaction;
    private final List<TextDisplay> hologramLines = new ArrayList<TextDisplay>();
    private BukkitTask rotationTask;
    private BukkitTask animationTask;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private float rotationAngle = 0.0f;
    private final Map<String, Object> animationState = new HashMap<String, Object>();

    public FloatingHead(xHeadTurns plugin, String name) {
        this.plugin = plugin;
        this.name = name;
    }

    public void spawn() {
        ConfigurationSection config = this.plugin.getConfigManager().getConfig().getConfigurationSection("heads." + this.name);
        if (config == null) {
            return;
        }
        Location location = this.plugin.getConfigManager().getLocation("heads." + this.name);
        if (location == null || location.getWorld() == null) {
            return;
        }
        location.getWorld().getChunkAtAsync(location).thenAccept(chunk -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            float scale = (float)config.getDouble("scale", 1.0);
            this.interaction = (Interaction)location.getWorld().spawn(location, Interaction.class, e -> {
                e.setInteractionWidth(scale);
                e.setInteractionHeight(scale);
            });
            this.itemDisplay = (ItemDisplay)location.getWorld().spawn(location, ItemDisplay.class, e -> {
                e.setInterpolationDuration(1);
                e.setInterpolationDelay(-1);
                Transformation transformation = e.getTransformation();
                transformation.getScale().set(scale);
                transformation.getTranslation().set(0.0f, -scale / 2.0f, 0.0f);
                e.setTransformation(transformation);
            });
            this.setHeadItem();
            this.startRotationTask();
            this.createHologram();
            this.startAnimation();
        }));
    }

    private void createHologram() {
        ConfigurationSection holoConfig = this.plugin.getConfigManager().getConfig().getConfigurationSection("heads." + this.name + ".hologram");
        if (holoConfig == null) {
            return;
        }
        this.hologramLines.forEach(Entity::remove);
        this.hologramLines.clear();
        List lines = holoConfig.getStringList("lines");
        float scale = (float)this.plugin.getConfigManager().getConfig().getDouble("heads." + this.name + ".scale", 1.0);
        Location baseLocation = this.itemDisplay.getLocation().clone().add(0.0, (double)(scale / 2.0f) + holoConfig.getDouble("offset-y", 0.3), 0.0);
        for (int i = 0; i < lines.size(); ++i) {
            int index = i;
            Location lineLocation = baseLocation.clone().subtract(0.0, 0.3 * (double)i, 0.0);
            TextDisplay textDisplay = (TextDisplay)lineLocation.getWorld().spawn(lineLocation, TextDisplay.class, e -> {
                TextComponent textComponent = LegacyComponentSerializer.legacyAmpersand().deserialize((String)lines.get(index));
                e.text((Component)textComponent);
                e.setBillboard(Display.Billboard.CENTER);
                e.setBackgroundColor(Color.fromARGB((int)0, (int)0, (int)0, (int)0));
                e.setAlignment(TextDisplay.TextAlignment.CENTER);
            });
            this.hologramLines.add(textDisplay);
        }
    }

    private void updateHologramLines(Player player) {
        if (this.hologramLines.isEmpty() || player == null) {
            return;
        }
        List lines = this.plugin.getConfigManager().getConfig().getStringList("heads." + this.name + ".hologram.lines");
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            lines = PlaceholderAPI.setPlaceholders((Player)player, (List)lines);
        }
        for (int i = 0; i < Math.min(this.hologramLines.size(), lines.size()); ++i) {
            TextDisplay textDisplay = this.hologramLines.get(i);
            TextComponent textComponent = LegacyComponentSerializer.legacyAmpersand().deserialize((String)lines.get(i));
            textDisplay.text((Component)textComponent);
        }
    }

    public void remove() {
        if (this.rotationTask != null) {
            this.rotationTask.cancel();
        }
        if (this.animationTask != null) {
            this.animationTask.cancel();
        }
        if (this.itemDisplay != null) {
            this.itemDisplay.remove();
        }
        if (this.interaction != null) {
            this.interaction.remove();
        }
        this.hologramLines.forEach(Entity::remove);
        this.hologramLines.clear();
    }

    private void setHeadItem() {
        String texture = this.plugin.getConfigManager().getConfig().getString("heads." + this.name + ".texture", "Steve");
        ItemStack headItem = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)headItem.getItemMeta();
        if (skullMeta == null) {
            return;
        }
        this.getProfile(texture).thenAccept(profile -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            skullMeta.setPlayerProfile(profile);
            headItem.setItemMeta((ItemMeta)skullMeta);
            if (this.itemDisplay != null && !this.itemDisplay.isDead()) {
                this.itemDisplay.setItemStack(headItem);
            }
        }));
    }

    private CompletableFuture<PlayerProfile> getProfile(String texture) {
        if (texture.length() > 100) {
            PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID());
            profile.getProperties().add(new ProfileProperty("textures", texture));
            return CompletableFuture.completedFuture(profile);
        }
        return Bukkit.createProfile((String)texture).update();
    }

    private void startRotationTask() {
        final double speed = this.plugin.getConfigManager().getConfig().getDouble("heads." + this.name + ".speed", 0.0);
        if (speed == 0.0) {
            return;
        }
        this.rotationTask = new BukkitRunnable(){

            public void run() {
                if (FloatingHead.this.itemDisplay == null || FloatingHead.this.itemDisplay.isDead()) {
                    this.cancel();
                    return;
                }
                FloatingHead.this.rotationAngle = (float)((double)FloatingHead.this.rotationAngle + speed);
                if (FloatingHead.this.rotationAngle >= 360.0f) {
                    FloatingHead.this.rotationAngle -= 360.0f;
                }
                Transformation transformation = FloatingHead.this.itemDisplay.getTransformation();
                transformation.getLeftRotation().set(new AxisAngle4f((float)Math.toRadians(FloatingHead.this.rotationAngle), 0.0f, 1.0f, 0.0f));
                FloatingHead.this.itemDisplay.setTransformation(transformation);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void startAnimation() {
        final ConfigurationSection animConfig = this.plugin.getConfigManager().getConfig().getConfigurationSection("heads." + this.name + ".animation");
        if (animConfig == null) {
            return;
        }
        AnimationType type = AnimationType.fromString(animConfig.getString("type", "NONE"));
        if (type == null || type == AnimationType.NONE) {
            return;
        }
        this.animationState.clear();
        final Animation animation = type.createAnimation();
        this.animationTask = new BukkitRunnable(){

            public void run() {
                if (FloatingHead.this.itemDisplay == null || FloatingHead.this.itemDisplay.isDead()) {
                    this.cancel();
                    return;
                }
                animation.play(FloatingHead.this.itemDisplay, animConfig, FloatingHead.this.animationState);
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, (long)animConfig.getDouble("tick-delay", 2.0));
    }

    public void handleClick(Player player) {
        this.updateHologramLines(player);
        long cooldownTime = this.plugin.getConfigManager().getConfig().getLong("heads." + this.name + ".click-cooldown", 1L) * 1000L;
        if (cooldownTime > 0L) {
            long lastClick = this.cooldowns.getOrDefault(player.getUniqueId(), 0L);
            if (System.currentTimeMillis() - lastClick < cooldownTime) {
                this.plugin.getConfigManager().sendMessage((CommandSender)player, "on-cooldown", Map.of("{time}", String.valueOf((lastClick + cooldownTime - System.currentTimeMillis()) / 1000L + 1L)));
                return;
            }
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        }
        List commands = this.plugin.getConfigManager().getConfig().getStringList("heads." + this.name + ".commands");
        boolean placeholderApi = this.plugin.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI");
        for (String command : commands) {
            String parsedCommand = placeholderApi ? PlaceholderAPI.setPlaceholders((Player)player, (String)command) : command.replace("%player_name%", player.getName());
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)parsedCommand);
        }
    }

    public UUID getInteractionUUID() {
        return this.interaction != null ? this.interaction.getUniqueId() : null;
    }

    public Location getLocation() {
        return this.itemDisplay != null ? this.itemDisplay.getLocation() : null;
    }

    public ItemDisplay getItemDisplay() {
        return this.itemDisplay;
    }
}

