/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xheadturns.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jn.willfrydev.xheadturns.xHeadTurns;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class xHeadTurnsCommand
implements CommandExecutor,
TabCompleter {
    private final xHeadTurns plugin;

    public xHeadTurnsCommand(xHeadTurns plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String[] subArgs;
        String subCommand;
        String commandLabel;
        switch (commandLabel = command.getName().toLowerCase()) {
            case "xhtc": {
                subCommand = "create";
                subArgs = args;
                break;
            }
            case "xhtd": {
                subCommand = "delete";
                subArgs = args;
                break;
            }
            case "xhtr": {
                subCommand = "reload";
                subArgs = args;
                break;
            }
            default: {
                if (args.length == 0) {
                    this.sendHelpMessage(sender);
                    return true;
                }
                subCommand = args[0].toLowerCase();
                subArgs = Arrays.copyOfRange(args, 1, args.length);
            }
        }
        switch (subCommand) {
            case "help": {
                this.sendHelpMessage(sender);
                break;
            }
            case "reload": {
                if (!sender.hasPermission("xheadturns.reload")) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                    return true;
                }
                this.plugin.getConfigManager().reloadConfig();
                this.plugin.getHeadManager().reloadAllHeads();
                sender.sendMessage(this.plugin.getConfigManager().getMessage("reload-success"));
                break;
            }
            case "create": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("player-only"));
                    return true;
                }
                if (!sender.hasPermission("xheadturns.create")) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                    return true;
                }
                if (subArgs.length < 1) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("create-usage"));
                    return true;
                }
                this.plugin.getHeadManager().createHead((Player)sender, subArgs[0]);
                break;
            }
            case "delete": {
                if (!sender.hasPermission("xheadturns.delete")) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                    return true;
                }
                if (subArgs.length < 1) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("delete-usage"));
                    return true;
                }
                this.plugin.getHeadManager().deleteHead(subArgs[0], sender);
                break;
            }
            default: {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("unknown-command"));
            }
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        String commandLabel = command.getName().toLowerCase();
        if (commandLabel.equals("xhtc") || commandLabel.equals("xhtr")) {
            return Collections.emptyList();
        }
        if (commandLabel.equals("xhtd") && args.length == 1 && sender.hasPermission("xheadturns.delete")) {
            return this.plugin.getHeadManager().getHeadNames().stream().filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (commandLabel.equals("xheadturns")) {
            if (args.length == 1) {
                ArrayList<String> subcommands = new ArrayList<String>(Arrays.asList("help", "reload", "create", "delete"));
                return subcommands.stream().filter(s -> sender.hasPermission("xheadturns." + s) || s.equals("help")).filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("delete") && sender.hasPermission("xheadturns.delete")) {
                return this.plugin.getHeadManager().getHeadNames().stream().filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private void sendHelpMessage(CommandSender sender) {
        this.plugin.getConfigManager().getHelpMessage().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
    }
}

