/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xheadturns.manager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jn.willfrydev.xheadturns.xHeadTurns;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final xHeadTurns plugin;
    private FileConfiguration dataConfig;
    private File configFile;
    private FileConfiguration messagesConfig;

    public ConfigManager(xHeadTurns plugin) {
        this.plugin = plugin;
        this.saveDefaultConfig();
        this.loadMessages();
    }

    public void reloadConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
        try (InputStream defaultStream = this.plugin.getResource("config.yml");){
            if (defaultStream != null) {
                this.dataConfig.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream)));
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not load default config.");
        }
        this.loadMessages();
    }

    public FileConfiguration getConfig() {
        if (this.dataConfig == null) {
            this.reloadConfig();
        }
        return this.dataConfig;
    }

    public void saveConfig() {
        try {
            this.getConfig().save(this.configFile);
        }
        catch (IOException ex) {
            this.plugin.getLogger().severe("Could not save config to " + String.valueOf(this.configFile));
        }
    }

    public void saveDefaultConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        }
        if (!this.configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
    }

    public Location getLocation(String path) {
        World world;
        String worldName = this.getConfig().getString(path + ".location.world");
        World world2 = world = worldName != null ? Bukkit.getWorld((String)worldName) : null;
        if (world == null) {
            return null;
        }
        return new Location(world, this.getConfig().getDouble(path + ".location.x"), this.getConfig().getDouble(path + ".location.y"), this.getConfig().getDouble(path + ".location.z"));
    }

    public void createDefaultHeadConfig(String name, Location loc) {
        String path = "heads." + name;
        this.getConfig().set(path + ".location.world", (Object)loc.getWorld().getName());
        this.getConfig().set(path + ".location.x", (Object)loc.getX());
        this.getConfig().set(path + ".location.y", (Object)loc.getY());
        this.getConfig().set(path + ".location.z", (Object)loc.getZ());
        this.getConfig().set(path + ".texture", (Object)"Steve");
        this.getConfig().set(path + ".speed", (Object)2.5);
        this.getConfig().set(path + ".click-cooldown", (Object)1);
        this.getConfig().set(path + ".particle-type", (Object)"FLAME");
        this.getConfig().set(path + ".commands", Collections.singletonList("say Welcome, %player_name%!"));
        this.saveConfig();
    }

    public void loadMessages() {
        String lang = this.getConfig().getString("locale", "en");
        File messagesFile = new File(this.plugin.getDataFolder(), "messages/" + lang + ".yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages/" + lang + ".yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
        try (InputStream defaultStream = this.plugin.getResource("messages/" + lang + ".yml");){
            if (defaultStream != null) {
                this.messagesConfig.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream, StandardCharsets.UTF_8)));
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not load messages for locale: " + lang);
        }
    }

    public String getMessage(String key) {
        String prefix = this.messagesConfig.getString("prefix", "");
        String message = this.messagesConfig.getString(key, "&cMessage not found: " + key);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message.replace("{prefix}", prefix));
    }

    public List<String> getHelpMessage() {
        return this.messagesConfig.getStringList("help-message").stream().map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line)).collect(Collectors.toList());
    }
}

