/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xheadturns.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import jn.willfrydev.xheadturns.object.FloatingHead;
import jn.willfrydev.xheadturns.xHeadTurns;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EquipmentSlot;

public class HeadManager
implements Listener {
    private final xHeadTurns plugin;
    private final Map<String, FloatingHead> activeHeads = new HashMap<String, FloatingHead>();

    public HeadManager(xHeadTurns plugin) {
        this.plugin = plugin;
    }

    public void spawnAllHeads() {
        ConfigurationSection headsSection = this.plugin.getConfigManager().getConfig().getConfigurationSection("heads");
        if (headsSection == null) {
            return;
        }
        for (String headName : headsSection.getKeys(false)) {
            FloatingHead head = new FloatingHead(this.plugin, headName);
            head.spawn();
            this.activeHeads.put(headName.toLowerCase(), head);
        }
        this.plugin.getLogger().info(this.activeHeads.size() + " floating heads have been spawned.");
    }

    public void reloadAllHeads() {
        this.removeAllHeads();
        this.spawnAllHeads();
    }

    public void removeAllHeads() {
        this.activeHeads.values().forEach(FloatingHead::remove);
        this.activeHeads.clear();
    }

    public void createHead(Player player, String name) {
        if (this.activeHeads.containsKey(name.toLowerCase())) {
            player.sendMessage(this.plugin.getConfigManager().getMessage("create-fail-exists"));
            return;
        }
        Location location = player.getEyeLocation();
        this.plugin.getConfigManager().createDefaultHeadConfig(name, location);
        this.plugin.getConfigManager().reloadConfig();
        FloatingHead newHead = new FloatingHead(this.plugin, name);
        newHead.spawn();
        this.activeHeads.put(name.toLowerCase(), newHead);
        player.sendMessage(this.plugin.getConfigManager().getMessage("create-success").replace("{name}", name));
    }

    public void deleteHead(String name, CommandSender sender) {
        String lowerName = name.toLowerCase();
        if (!this.activeHeads.containsKey(lowerName)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("head-not-found"));
            return;
        }
        FloatingHead head = this.activeHeads.remove(lowerName);
        if (head != null) {
            head.remove();
        }
        this.plugin.getConfigManager().getConfig().set("heads." + name, null);
        this.plugin.getConfigManager().saveConfig();
        sender.sendMessage(this.plugin.getConfigManager().getMessage("delete-success").replace("{name}", name));
    }

    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        if (!(event.getRightClicked() instanceof ArmorStand) || !event.getHand().equals((Object)EquipmentSlot.HAND)) {
            return;
        }
        UUID clickedUUID = event.getRightClicked().getUniqueId();
        for (FloatingHead head : this.activeHeads.values()) {
            if (head.getArmorStandUUID() == null || !head.getArmorStandUUID().equals(clickedUUID)) continue;
            head.handleClick(event.getPlayer());
            event.setCancelled(true);
            return;
        }
    }

    public Set<String> getHeadNames() {
        ConfigurationSection headsSection = this.plugin.getConfigManager().getConfig().getConfigurationSection("heads");
        return headsSection != null ? headsSection.getKeys(false) : this.activeHeads.keySet();
    }

    public Map<String, FloatingHead> getActiveHeads() {
        return this.activeHeads;
    }
}

