/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xheadturns.object;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import jn.willfrydev.xheadturns.xHeadTurns;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FloatingHead {
    private final xHeadTurns plugin;
    private final String name;
    private ArmorStand armorStand;
    private BukkitRunnable rotationTask;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public FloatingHead(xHeadTurns plugin, String name) {
        this.plugin = plugin;
        this.name = name;
    }

    public void spawn() {
        Location location = this.plugin.getConfigManager().getLocation("heads." + this.name);
        if (location == null) {
            this.plugin.getLogger().severe("Location for head '" + this.name + "' is invalid.");
            return;
        }
        location.getWorld().getChunkAtAsync(location).thenAccept(chunk -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            this.armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class, as -> {
                as.setGravity(false);
                as.setCanPickupItems(false);
                as.setCustomNameVisible(false);
                as.setVisible(false);
                as.setMarker(false);
                as.setInvulnerable(true);
            });
            this.setHeadItem();
            this.startRotationTask();
        }));
    }

    private void setHeadItem() {
        String texture = this.plugin.getConfigManager().getConfig().getString("heads." + this.name + ".texture", "Steve");
        ItemStack headItem = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)headItem.getItemMeta();
        if (skullMeta == null) {
            return;
        }
        this.getProfile(texture).thenAccept(profile -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            skullMeta.setPlayerProfile(profile);
            headItem.setItemMeta((ItemMeta)skullMeta);
            if (this.armorStand != null && !this.armorStand.isDead()) {
                this.armorStand.getEquipment().setHelmet(headItem);
            }
        }));
    }

    private CompletableFuture<PlayerProfile> getProfile(String texture) {
        if (texture.length() > 100) {
            PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID());
            profile.getProperties().add(new ProfileProperty("textures", texture));
            return CompletableFuture.completedFuture(profile);
        }
        return Bukkit.createProfile((String)texture).update();
    }

    private void startRotationTask() {
        final double speed = this.plugin.getConfigManager().getConfig().getDouble("heads." + this.name + ".speed", 2.5);
        Particle particle = null;
        try {
            particle = Particle.valueOf((String)this.plugin.getConfigManager().getConfig().getString("heads." + this.name + ".particle-type", "GLOW").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid particle type for head '" + this.name + "'.");
        }
        final Particle finalParticle = particle;
        this.rotationTask = new BukkitRunnable(){

            public void run() {
                if (FloatingHead.this.armorStand == null || FloatingHead.this.armorStand.isDead()) {
                    this.cancel();
                    return;
                }
                FloatingHead.this.armorStand.setHeadPose(FloatingHead.this.armorStand.getHeadPose().add(0.0, Math.toRadians(speed), 0.0));
                if (finalParticle != null) {
                    FloatingHead.this.armorStand.getWorld().spawnParticle(finalParticle, FloatingHead.this.armorStand.getLocation().clone().add(0.0, 1.75, 0.0), 1, 0.2, 0.2, 0.2, 0.0);
                }
            }
        };
        this.rotationTask.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void handleClick(Player player) {
        long cooldownTime = this.plugin.getConfigManager().getConfig().getLong("heads." + this.name + ".click-cooldown", 1L) * 1000L;
        if (cooldownTime > 0L) {
            long lastClick;
            long currentTime = System.currentTimeMillis();
            if (currentTime - (lastClick = this.cooldowns.getOrDefault(player.getUniqueId(), 0L).longValue()) < cooldownTime) {
                String message = this.plugin.getConfigManager().getMessage("on-cooldown");
                player.sendMessage(message.replace("{time}", String.valueOf((lastClick + cooldownTime - currentTime) / 1000L + 1L)));
                return;
            }
            this.cooldowns.put(player.getUniqueId(), currentTime);
        }
        List commands = this.plugin.getConfigManager().getConfig().getStringList("heads." + this.name + ".commands");
        boolean placeholderApi = this.plugin.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI");
        for (String command : commands) {
            String parsedCommand = placeholderApi ? PlaceholderAPI.setPlaceholders((Player)player, (String)command) : command.replace("%player_name%", player.getName());
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)parsedCommand);
        }
    }

    public void remove() {
        if (this.rotationTask != null) {
            this.rotationTask.cancel();
        }
        if (this.armorStand != null) {
            this.armorStand.remove();
        }
    }

    public UUID getArmorStandUUID() {
        return this.armorStand != null ? this.armorStand.getUniqueId() : null;
    }

    public Location getLocation() {
        return this.armorStand != null ? this.armorStand.getLocation() : null;
    }

    public ArmorStand getArmorStand() {
        return this.armorStand;
    }
}

