/*
 * Decompiled with CFR 0.152.
 */
package com.example.randomdrops.commands;

import com.example.randomdrops.RandomDropsPlugin;
import com.example.randomdrops.enums.DropMode;
import com.example.randomdrops.enums.LuckDupeChance;
import com.example.randomdrops.managers.ConfigManager;
import com.example.randomdrops.managers.DropScheduler;
import com.example.randomdrops.managers.ItemManager;
import com.example.randomdrops.managers.PlayerManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class RandomDropsCommand
implements CommandExecutor,
TabCompleter {
    private final RandomDropsPlugin plugin;
    private final PlayerManager playerManager;
    private final DropScheduler dropScheduler;
    private final ConfigManager configManager;
    private final ItemManager itemManager;

    public RandomDropsCommand(RandomDropsPlugin plugin, PlayerManager playerManager, DropScheduler dropScheduler, ConfigManager configManager, ItemManager itemManager) {
        this.plugin = plugin;
        this.playerManager = playerManager;
        this.dropScheduler = dropScheduler;
        this.configManager = configManager;
        this.itemManager = itemManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("randomdrops.use")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "start": {
                if (this.dropScheduler.isRunning()) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Random Item Drops are already running!");
                    break;
                }
                this.dropScheduler.start();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Random Item Drops - by Dalilimonada started!");
                break;
            }
            case "stop": {
                if (!this.dropScheduler.isRunning()) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Random Item Drops are not running!");
                    break;
                }
                this.dropScheduler.stop();
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Random Item Drops stopped!");
                break;
            }
            case "add": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rd add <player>");
                    return true;
                }
                this.handleAddPlayer(sender, args[1]);
                break;
            }
            case "remove": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rd remove <player>");
                    return true;
                }
                this.handleRemovePlayer(sender, args[1]);
                break;
            }
            case "playerlist": {
                this.handlePlayerList(sender);
                break;
            }
            case "setting": {
                if (args.length < 3) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rd setting <key> <value>");
                    return true;
                }
                this.handleSetting(sender, args[1], args[2]);
                break;
            }
            case "help": {
                this.sendHelp(sender);
                break;
            }
            case "reset": {
                this.handleReset(sender);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private void handleAddPlayer(CommandSender sender, String playerName) {
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
            return;
        }
        if (this.playerManager.addPlayer(target.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Added " + target.getName() + " to the drop list!");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + " is already in the drop list!");
        }
    }

    private void handleRemovePlayer(CommandSender sender, String playerName) {
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
            return;
        }
        if (this.playerManager.removePlayer(target.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Removed " + target.getName() + " from the drop list!");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + " is not in the drop list!");
        }
    }

    private void handlePlayerList(CommandSender sender) {
        List<String> playerNames = this.playerManager.getPlayerNames();
        if (playerNames.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "No players in the drop list!");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Players in drop list: " + String.join((CharSequence)", ", playerNames));
        }
    }

    private void handleSetting(CommandSender sender, String key, String value) {
        switch (key.toLowerCase()) {
            case "dropsinterval": {
                try {
                    int ticks = Integer.parseInt(value);
                    if (ticks < 1) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Drop interval must be at least 1 tick.");
                        return;
                    }
                    this.configManager.setDropInterval(ticks);
                    this.dropScheduler.updateInterval();
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Drop interval set to " + ticks + " ticks.");
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number.");
                }
                break;
            }
            case "doeggsdrop": {
                this.configManager.setDropEggs(value.equalsIgnoreCase("true"));
                this.itemManager.updateItemPool();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "DoEggsDrop set to " + value);
                break;
            }
            case "dropmode": {
                try {
                    DropMode mode = DropMode.valueOf(value.toUpperCase());
                    this.configManager.setDropMode(mode);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "DropMode set to " + mode.name().toLowerCase());
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid DropMode. Use: normal, stacks, line.");
                }
                break;
            }
            case "drops": {
                try {
                    int drops = Integer.parseInt(value);
                    if (drops < 1) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Drops must be at least 1.");
                        return;
                    }
                    this.configManager.setDropsPerInterval(drops);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Drops per interval set to " + drops);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number.");
                }
                break;
            }
            case "senditemfeedback": {
                this.configManager.setSendItemFeedback(value.equalsIgnoreCase("true"));
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "SendItemFeedback set to " + value);
                break;
            }
            case "everyonesame": {
                this.configManager.setEveryoneSame(value.equalsIgnoreCase("true"));
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "EveryoneSame set to " + value);
                break;
            }
            case "luckdupe": {
                this.configManager.setLuckDupe(value.equalsIgnoreCase("true"));
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "LuckDupe set to " + value);
                break;
            }
            case "sendluckdupefeedback": {
                this.configManager.setSendLuckDupeFeedback(value.equalsIgnoreCase("true"));
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "SendLuckDupeFeedback set to " + value);
                break;
            }
            case "luckdupechance": {
                try {
                    LuckDupeChance chance = LuckDupeChance.valueOf(value.toUpperCase());
                    this.configManager.setLuckDupeChance(chance);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "LuckDupeChance set to " + chance.name().toLowerCase());
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid LuckDupeChance. Use: huge, large, big, normal, small, tiny.");
                }
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown setting: " + key);
            }
        }
    }

    private void handleReset(CommandSender sender) {
        if (this.dropScheduler.isRunning()) {
            this.dropScheduler.stop();
        }
        this.playerManager.getDropPlayers().clear();
        this.playerManager.savePlayers();
        this.configManager.setDropInterval(200);
        this.configManager.setDropEggs(true);
        this.configManager.setDropMode(DropMode.NORMAL);
        this.configManager.setDropsPerInterval(1);
        this.configManager.setEveryoneSame(false);
        this.configManager.setSendItemFeedback(true);
        this.configManager.setLuckDupe(true);
        this.configManager.setSendLuckDupeFeedback(true);
        this.configManager.setLuckDupeChance(LuckDupeChance.NORMAL);
        this.itemManager.updateItemPool();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Reset completed:");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "- Stopped random drops");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "- Removed all players from drop list");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "- Reset all settings to defaults:");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  * DropsInterval: 200 ticks");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  * DoEggsDrop: true");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  * DropMode: normal");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  * Drops: 1");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  * EveryoneSame: false");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  * SendItemFeedback: true");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  * LuckDupe: true");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  * SendLuckDupeFeedback: true");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  * LuckDupeChance: normal");
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Random Drops Help ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd help" + String.valueOf(ChatColor.WHITE) + " - Show this help message");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd start" + String.valueOf(ChatColor.WHITE) + " - Start random drops");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd stop" + String.valueOf(ChatColor.WHITE) + " - Stop random drops");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd add <player>" + String.valueOf(ChatColor.WHITE) + " - Add player to drop list");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd remove <player>" + String.valueOf(ChatColor.WHITE) + " - Remove player from drop list");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd playerlist" + String.valueOf(ChatColor.WHITE) + " - Show players in drop list");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd setting DropsInterval <ticks>" + String.valueOf(ChatColor.WHITE) + " - Set drop interval");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd setting Drops <number>" + String.valueOf(ChatColor.WHITE) + " - Set how many items are dropped");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd setting DoEggsDrop <true/false>" + String.valueOf(ChatColor.WHITE) + " - Toggle dropping spawn eggs");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd setting DropMode <normal/stacks/line>" + String.valueOf(ChatColor.WHITE) + " - Set drop mode");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd setting SendItemFeedback <true/false>" + String.valueOf(ChatColor.WHITE) + " - Toggle 'You received...' messages");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd setting EveryoneSame <true/false>" + String.valueOf(ChatColor.WHITE) + " - Everyone receives the same item");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd setting LuckDupe <true/false>" + String.valueOf(ChatColor.WHITE) + " - Enable luck dupe system");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd setting SendLuckDupeFeedback <true/false>" + String.valueOf(ChatColor.WHITE) + " - Toggle luck dupe messages");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd setting LuckDupeChance <huge/large/big/normal/small/tiny>" + String.valueOf(ChatColor.WHITE) + " - Set luck dupe chances");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd reset" + String.valueOf(ChatColor.WHITE) + " - Reset plugin (stop drops, clear players, enable eggs)");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd setting LuckDupe <true/false>" + String.valueOf(ChatColor.WHITE) + " - Enable luck dupe system");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd setting SendLuckDupeFeedback <true/false>" + String.valueOf(ChatColor.WHITE) + " - Toggle luck dupe messages");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd setting LuckDupeChance <huge/large/big/normal/small/tiny>" + String.valueOf(ChatColor.WHITE) + " - Set luck dupe chances");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd reset" + String.valueOf(ChatColor.WHITE) + " - Reset plugin (stop drops, clear players, enable eggs)");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block26: {
            block27: {
                String subCommand;
                block25: {
                    completions = new ArrayList<String>();
                    if (args.length != 1) break block25;
                    completions.addAll(Arrays.asList("help", "setting", "start", "stop", "add", "remove", "playerlist", "reset"));
                    break block26;
                }
                if (args.length != 2) break block27;
                switch (subCommand = args[0].toLowerCase()) {
                    case "add": 
                    case "remove": {
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            completions.add(player.getName());
                        }
                        break block26;
                    }
                    case "setting": {
                        completions.addAll(Arrays.asList("dropsinterval", "drops", "doeggsdrop", "dropmode", "senditemfeedback", "everyonesame", "luckdupe", "sendluckdupefeedback", "luckdupechance"));
                    }
                }
                break block26;
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("setting")) {
                String key;
                switch (key = args[1].toLowerCase()) {
                    case "doeggsdrop": 
                    case "senditemfeedback": 
                    case "everyonesame": 
                    case "luckdupe": 
                    case "sendluckdupefeedback": {
                        completions.addAll(Arrays.asList("true", "false"));
                        break;
                    }
                    case "dropmode": {
                        completions.addAll(Arrays.asList("normal", "stacks", "line"));
                        break;
                    }
                    case "luckdupechance": {
                        completions.addAll(Arrays.asList("huge", "large", "big", "normal", "small", "tiny"));
                    }
                }
            }
        }
        return completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).toList();
    }
}

