/*
 * Decompiled with CFR 0.152.
 */
package com.example.randomdrops.enums;

import java.util.Random;

public enum LuckDupeChance {
    HUGE(new double[]{0.0, 50.0, 35.0, 25.0, 12.0, 6.0, 3.0, 1.5, 0.8, 0.2}),
    LARGE(new double[]{0.0, 30.0, 20.0, 12.0, 6.0, 3.0, 1.5, 0.8, 0.4, 0.1}),
    BIG(new double[]{0.0, 16.0, 10.0, 5.0, 2.5, 1.5, 0.9, 0.5, 0.25, 0.05}),
    NORMAL(new double[]{0.0, 8.0, 5.0, 2.5, 1.25, 0.81, 0.44, 0.2, 0.1, 0.02}),
    SMALL(new double[]{0.0, 4.0, 2.5, 1.25, 0.6, 0.3, 0.15, 0.08, 0.04, 0.01}),
    TINY(new double[]{0.0, 1.0, 0.5, 0.25, 0.1, 0.05, 0.02, 0.01, 0.005, 0.001});

    private final double[] chances;
    private static final Random random;

    private LuckDupeChance(double[] chances) {
        this.chances = chances;
    }

    public int calculateDupeMultiplier() {
        double roll = random.nextDouble() * 100.0;
        double cumulative = 0.0;
        for (int i = 1; i < this.chances.length; ++i) {
            if (!(roll <= (cumulative += this.chances[i]))) continue;
            return i + 1;
        }
        return 1;
    }

    static {
        random = new Random();
    }
}

