/*
 * Decompiled with CFR 0.152.
 */
package com.example.randomdrops.managers;

import com.example.randomdrops.RandomDropsPlugin;
import com.example.randomdrops.enums.DropMode;
import com.example.randomdrops.enums.LuckDupeChance;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final RandomDropsPlugin plugin;
    private FileConfiguration config;
    private static final int DEFAULT_DROP_INTERVAL = 200;
    private static final boolean DEFAULT_DROP_EGGS = true;
    private static final DropMode DEFAULT_DROP_MODE = DropMode.NORMAL;
    private static final int DEFAULT_DROPS_PER_INTERVAL = 1;
    private static final boolean DEFAULT_SEND_ITEM_FEEDBACK = true;
    private static final boolean DEFAULT_EVERYONE_SAME = false;
    private static final boolean DEFAULT_LUCK_DUPE = true;
    private static final boolean DEFAULT_SEND_LUCK_DUPE_FEEDBACK = true;
    private static final LuckDupeChance DEFAULT_LUCK_DUPE_CHANCE = LuckDupeChance.NORMAL;

    public ConfigManager(RandomDropsPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
        if (!this.config.contains("drops-interval")) {
            this.config.set("drops-interval", (Object)200);
        }
        if (!this.config.contains("do-eggs-drop")) {
            this.config.set("do-eggs-drop", (Object)true);
        }
        if (!this.config.contains("drop-mode")) {
            this.config.set("drop-mode", (Object)DEFAULT_DROP_MODE.name());
        }
        if (!this.config.contains("drops-per-interval")) {
            this.config.set("drops-per-interval", (Object)1);
        }
        if (!this.config.contains("send-item-feedback")) {
            this.config.set("send-item-feedback", (Object)true);
        }
        if (!this.config.contains("everyone-same")) {
            this.config.set("everyone-same", (Object)false);
        }
        if (!this.config.contains("luck-dupe")) {
            this.config.set("luck-dupe", (Object)true);
        }
        if (!this.config.contains("send-luck-dupe-feedback")) {
            this.config.set("send-luck-dupe-feedback", (Object)true);
        }
        if (!this.config.contains("luck-dupe-chance")) {
            this.config.set("luck-dupe-chance", (Object)DEFAULT_LUCK_DUPE_CHANCE.name());
        }
        this.saveConfig();
        this.plugin.getLogger().info("Configuration loaded");
    }

    public void saveConfig() {
        this.plugin.saveConfig();
    }

    private FileConfiguration getConfig() {
        if (this.config == null) {
            throw new IllegalStateException("Config has not been loaded. Call loadConfig() first.");
        }
        return this.config;
    }

    public int getDropInterval() {
        return this.getConfig().getInt("drops-interval", 200);
    }

    public void setDropInterval(int interval) {
        this.getConfig().set("drops-interval", (Object)interval);
        this.saveConfig();
    }

    public boolean isDropEggs() {
        return this.getConfig().getBoolean("do-eggs-drop", true);
    }

    public void setDropEggs(boolean dropEggs) {
        this.getConfig().set("do-eggs-drop", (Object)dropEggs);
        this.saveConfig();
    }

    public DropMode getDropMode() {
        try {
            return DropMode.valueOf(this.getConfig().getString("drop-mode", DEFAULT_DROP_MODE.name()));
        }
        catch (IllegalArgumentException e) {
            return DEFAULT_DROP_MODE;
        }
    }

    public void setDropMode(DropMode mode) {
        this.getConfig().set("drop-mode", (Object)mode.name());
        this.saveConfig();
    }

    public int getDropsPerInterval() {
        return this.getConfig().getInt("drops-per-interval", 1);
    }

    public void setDropsPerInterval(int drops) {
        this.getConfig().set("drops-per-interval", (Object)drops);
        this.saveConfig();
    }

    public boolean isSendItemFeedback() {
        return this.getConfig().getBoolean("send-item-feedback", true);
    }

    public void setSendItemFeedback(boolean value) {
        this.config.set("send-item-feedback", (Object)value);
        this.saveConfig();
    }

    public boolean isEveryoneSame() {
        return this.getConfig().getBoolean("everyone-same", false);
    }

    public void setEveryoneSame(boolean value) {
        this.getConfig().set("everyone-same", (Object)value);
        this.saveConfig();
    }

    public boolean isLuckDupe() {
        return this.getConfig().getBoolean("luck-dupe", true);
    }

    public void setLuckDupe(boolean value) {
        this.getConfig().set("luck-dupe", (Object)value);
        this.saveConfig();
    }

    public boolean isSendLuckDupeFeedback() {
        return this.getConfig().getBoolean("send-luck-dupe-feedback", true);
    }

    public void setSendLuckDupeFeedback(boolean value) {
        this.getConfig().set("send-luck-dupe-feedback", (Object)value);
        this.saveConfig();
    }

    public LuckDupeChance getLuckDupeChance() {
        try {
            return LuckDupeChance.valueOf(this.getConfig().getString("luck-dupe-chance", DEFAULT_LUCK_DUPE_CHANCE.name()));
        }
        catch (IllegalArgumentException e) {
            return DEFAULT_LUCK_DUPE_CHANCE;
        }
    }

    public void setLuckDupeChance(LuckDupeChance chance) {
        this.getConfig().set("luck-dupe-chance", (Object)chance.name());
        this.saveConfig();
    }
}

