/*
 * Decompiled with CFR 0.152.
 */
package com.example.randomdrops.managers;

import com.example.randomdrops.RandomDropsPlugin;
import com.example.randomdrops.enums.DropMode;
import com.example.randomdrops.enums.LuckDupeChance;
import com.example.randomdrops.managers.ConfigManager;
import com.example.randomdrops.managers.ItemManager;
import com.example.randomdrops.managers.PlayerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class DropScheduler {
    private final RandomDropsPlugin plugin;
    private final PlayerManager playerManager;
    private final ItemManager itemManager;
    private final ConfigManager configManager;
    private BukkitTask dropTask;
    private boolean running = false;

    public DropScheduler(RandomDropsPlugin plugin, PlayerManager playerManager, ItemManager itemManager, ConfigManager configManager) {
        this.plugin = plugin;
        this.playerManager = playerManager;
        this.itemManager = itemManager;
        this.configManager = configManager;
    }

    public void start() {
        List<Player> onlinePlayers;
        if (this.running) {
            return;
        }
        if (this.configManager.isSetDayAtStart()) {
            onlinePlayers = this.playerManager.getOnlineDropPlayers();
            for (Player player : onlinePlayers) {
                player.getWorld().setTime(1000L);
            }
        }
        if (this.configManager.isWeatherClearAtStart()) {
            onlinePlayers = this.playerManager.getOnlineDropPlayers();
            for (Player player : onlinePlayers) {
                player.getWorld().setStorm(false);
                player.getWorld().setThundering(false);
            }
        }
        if (this.configManager.isClearInventoryAtStart()) {
            onlinePlayers = this.playerManager.getOnlineDropPlayers();
            for (Player player : onlinePlayers) {
                if (player.getGameMode() == GameMode.SPECTATOR) continue;
                player.getInventory().clear();
            }
        }
        this.running = true;
        this.scheduleDropTask();
        this.plugin.getLogger().info("Random Item Drops - by Dalilimonada started");
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (this.dropTask != null) {
            this.dropTask.cancel();
            this.dropTask = null;
        }
        this.plugin.getLogger().info("Random Item Drops stopped");
    }

    public void updateInterval() {
        if (this.running) {
            if (this.dropTask != null) {
                this.dropTask.cancel();
                this.dropTask = null;
            }
            this.scheduleDropTask();
        }
    }

    private void scheduleDropTask() {
        int interval = this.configManager.getDropInterval();
        this.dropTask = new BukkitRunnable(){

            public void run() {
                if (!DropScheduler.this.running) {
                    this.cancel();
                    return;
                }
                DropScheduler.this.performDrops();
            }
        }.runTaskTimer((Plugin)this.plugin, (long)interval, (long)interval);
    }

    private void performDrops() {
        List<Object> onlinePlayers = this.playerManager.getOnlineDropPlayers();
        if (onlinePlayers.isEmpty()) {
            return;
        }
        if ((onlinePlayers = onlinePlayers.stream().filter(player -> player.getGameMode() != GameMode.SPECTATOR).collect(Collectors.toList())).isEmpty()) {
            return;
        }
        int dropsPerInterval = this.configManager.getDropsPerInterval();
        DropMode mode = this.configManager.getDropMode();
        boolean sendFeedback = this.configManager.isSendItemFeedback();
        boolean everyoneSame = this.configManager.isEveryoneSame();
        boolean luckDupe = this.configManager.isLuckDupe();
        boolean sendLuckDupeFeedback = this.configManager.isSendLuckDupeFeedback();
        LuckDupeChance luckDupeChance = this.configManager.getLuckDupeChance();
        List<ItemStack> baseItems = everyoneSame ? this.itemManager.getRandomItems(dropsPerInterval) : null;
        for (Player player2 : onlinePlayers) {
            List<ItemStack> items;
            List<ItemStack> list = items = everyoneSame && baseItems != null ? this.cloneItems(baseItems) : this.itemManager.getRandomItems(dropsPerInterval);
            if (luckDupe) {
                items = this.applyLuckDupe(items, luckDupeChance, player2, sendLuckDupeFeedback);
            }
            this.giveItemsToPlayer(player2, items, mode);
            if (!sendFeedback) continue;
            if (dropsPerInterval == 1) {
                player2.sendMessage("\u00a7aYou received: \u00a7f" + items.get(0).getAmount() + "x " + this.formatMaterialName(items.get(0).getType()));
                continue;
            }
            player2.sendMessage("\u00a7aYou received \u00a7f" + dropsPerInterval + "\u00a7a random items!");
        }
    }

    private List<ItemStack> applyLuckDupe(List<ItemStack> items, LuckDupeChance luckDupeChance, Player player, boolean sendFeedback) {
        ArrayList<ItemStack> dupedItems = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            int dupeMultiplier = luckDupeChance.calculateDupeMultiplier();
            if (dupeMultiplier > 1) {
                ItemStack dupedItem = item.clone();
                dupedItem.setAmount(item.getAmount() * dupeMultiplier);
                dupedItems.add(dupedItem);
                if (!sendFeedback) continue;
                player.sendMessage("\u00a76You got lucky! Your item duped \u00a7e" + dupeMultiplier + "\u00a76 times!");
                continue;
            }
            dupedItems.add(item);
        }
        return dupedItems;
    }

    private void giveItemsToPlayer(Player player, List<ItemStack> items, DropMode mode) {
        if (mode == DropMode.LINE) {
            if (items.size() != 1) {
                items = Collections.singletonList(items.get(0));
            }
            ItemStack item = items.get(0);
            Material material = item.getType();
            int maxStack = material.getMaxStackSize();
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = new ItemStack(material, maxStack);
                this.addToInventoryOrDrop(player, stack);
            }
        } else if (mode == DropMode.STACKS) {
            for (ItemStack item : items) {
                item.setAmount(item.getMaxStackSize());
                this.addToInventoryOrDrop(player, item);
            }
        } else {
            for (ItemStack item : items) {
                this.addToInventoryOrDrop(player, item);
            }
        }
    }

    private void addToInventoryOrDrop(Player player, ItemStack item) {
        if (player.getInventory().firstEmpty() != -1) {
            player.getInventory().addItem(new ItemStack[]{item});
        } else {
            player.getWorld().dropItemNaturally(player.getLocation(), item);
        }
    }

    private List<ItemStack> cloneItems(List<ItemStack> items) {
        ArrayList<ItemStack> clones = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            clones.add(item.clone());
        }
        return clones;
    }

    private String formatMaterialName(Material material) {
        String name = material.name().toLowerCase().replace("_", " ");
        String[] words = name.split(" ");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
        }
        return formatted.toString();
    }

    public boolean isRunning() {
        return this.running;
    }
}

