/*
 * Decompiled with CFR 0.152.
 */
package com.example.randomdrops.managers;

import com.example.randomdrops.RandomDropsPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerManager {
    private final RandomDropsPlugin plugin;
    private final Set<UUID> dropPlayers;
    private File playersFile;
    private FileConfiguration playersConfig;

    public PlayerManager(RandomDropsPlugin plugin) {
        this.plugin = plugin;
        this.dropPlayers = new HashSet<UUID>();
        this.setupPlayersFile();
    }

    private void setupPlayersFile() {
        this.playersFile = new File(this.plugin.getDataFolder(), "players.yml");
        if (!this.playersFile.exists()) {
            this.playersFile.getParentFile().mkdirs();
            this.plugin.saveResource("players.yml", false);
        }
        this.playersConfig = YamlConfiguration.loadConfiguration((File)this.playersFile);
    }

    public boolean addPlayer(UUID playerId) {
        return this.dropPlayers.add(playerId);
    }

    public boolean removePlayer(UUID playerId) {
        return this.dropPlayers.remove(playerId);
    }

    public Set<UUID> getDropPlayers() {
        return new HashSet<UUID>(this.dropPlayers);
    }

    public List<Player> getOnlineDropPlayers() {
        ArrayList<Player> onlinePlayers = new ArrayList<Player>();
        for (UUID playerId : this.dropPlayers) {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player == null || !player.isOnline() || player.getGameMode() == GameMode.SPECTATOR) continue;
            onlinePlayers.add(player);
        }
        return onlinePlayers;
    }

    public List<String> getPlayerNames() {
        return this.dropPlayers.stream().map(Bukkit::getOfflinePlayer).map(player -> player.getName() != null ? player.getName() : "Unknown").collect(Collectors.toList());
    }

    public void loadPlayers() {
        List playerUUIDs = this.playersConfig.getStringList("players");
        this.dropPlayers.clear();
        for (String uuidStr : playerUUIDs) {
            try {
                this.dropPlayers.add(UUID.fromString(uuidStr));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid UUID in players.yml: " + uuidStr);
            }
        }
        this.plugin.getLogger().info("Loaded " + this.dropPlayers.size() + " players for drops");
    }

    public void savePlayers() {
        List playerUUIDs = this.dropPlayers.stream().map(UUID::toString).collect(Collectors.toList());
        this.playersConfig.set("players", playerUUIDs);
        try {
            this.playersConfig.save(this.playersFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save players.yml: " + e.getMessage());
        }
    }
}

