/*
 * Decompiled with CFR 0.152.
 */
package com.example.randomdrops.commands;

import com.example.randomdrops.RandomDropsPlugin;
import com.example.randomdrops.enums.DropMode;
import com.example.randomdrops.managers.ConfigManager;
import com.example.randomdrops.managers.DropScheduler;
import com.example.randomdrops.managers.ItemManager;
import com.example.randomdrops.managers.PlayerManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class RandomDropsCommand
implements CommandExecutor,
TabCompleter {
    private final RandomDropsPlugin plugin;
    private final PlayerManager playerManager;
    private final DropScheduler dropScheduler;
    private final ConfigManager configManager;
    private final ItemManager itemManager;

    public RandomDropsCommand(RandomDropsPlugin plugin, PlayerManager playerManager, DropScheduler dropScheduler, ConfigManager configManager, ItemManager itemManager) {
        this.plugin = plugin;
        this.playerManager = playerManager;
        this.dropScheduler = dropScheduler;
        this.configManager = configManager;
        this.itemManager = itemManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("randomdrops.use")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "start": {
                if (this.dropScheduler.isRunning()) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Random drops are already running!");
                    break;
                }
                this.dropScheduler.start();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Random drops started!");
                break;
            }
            case "stop": {
                if (!this.dropScheduler.isRunning()) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Random drops are not running!");
                    break;
                }
                this.dropScheduler.stop();
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Random drops stopped!");
                break;
            }
            case "add": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rd add <player>");
                    return true;
                }
                this.handleAddPlayer(sender, args[1]);
                break;
            }
            case "remove": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rd remove <player>");
                    return true;
                }
                this.handleRemovePlayer(sender, args[1]);
                break;
            }
            case "playerlist": {
                this.handlePlayerList(sender);
                break;
            }
            case "set": {
                if (args.length < 3 || !args[1].equalsIgnoreCase("timer")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rd set timer <ticks>");
                    return true;
                }
                this.handleSetTimer(sender, args[2]);
                break;
            }
            case "dropeggs": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rd dropeggs <on/off>");
                    return true;
                }
                this.handleDropEggs(sender, args[1]);
                break;
            }
            case "mode": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rd mode <normal/stacks/line>");
                    return true;
                }
                this.handleMode(sender, args[1]);
                break;
            }
            case "drops": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rd drops <number>");
                    return true;
                }
                this.handleDrops(sender, args[1]);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private void handleAddPlayer(CommandSender sender, String playerName) {
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
            return;
        }
        if (this.playerManager.addPlayer(target.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Added " + target.getName() + " to the drop list!");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + " is already in the drop list!");
        }
    }

    private void handleRemovePlayer(CommandSender sender, String playerName) {
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
            return;
        }
        if (this.playerManager.removePlayer(target.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Removed " + target.getName() + " from the drop list!");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + " is not in the drop list!");
        }
    }

    private void handlePlayerList(CommandSender sender) {
        List<String> playerNames = this.playerManager.getPlayerNames();
        if (playerNames.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "No players in the drop list!");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Players in drop list: " + String.join((CharSequence)", ", playerNames));
        }
    }

    private void handleSetTimer(CommandSender sender, String ticksStr) {
        try {
            int ticks = Integer.parseInt(ticksStr);
            if (ticks < 1) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Timer must be at least 1 tick!");
                return;
            }
            this.configManager.setDropInterval(ticks);
            this.dropScheduler.updateInterval();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Drop timer set to " + ticks + " ticks!");
        }
        catch (NumberFormatException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number!");
        }
    }

    private void handleDropEggs(CommandSender sender, String toggle) {
        boolean enable = toggle.equalsIgnoreCase("on") || toggle.equalsIgnoreCase("true");
        this.configManager.setDropEggs(enable);
        this.itemManager.updateItemPool();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Drop eggs " + (enable ? "enabled" : "disabled") + "!");
    }

    private void handleMode(CommandSender sender, String modeStr) {
        try {
            DropMode mode = DropMode.valueOf(modeStr.toUpperCase());
            this.configManager.setDropMode(mode);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Drop mode set to " + mode.name().toLowerCase() + "!");
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid mode! Use: normal, stacks, or line");
        }
    }

    private void handleDrops(CommandSender sender, String dropsStr) {
        try {
            int drops = Integer.parseInt(dropsStr);
            if (drops < 1) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Drop count must be at least 1!");
                return;
            }
            this.configManager.setDropsPerInterval(drops);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Drops per interval set to " + drops + "!");
        }
        catch (NumberFormatException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number!");
        }
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Random Drops Commands ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd start" + String.valueOf(ChatColor.WHITE) + " - Start random drops");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd stop" + String.valueOf(ChatColor.WHITE) + " - Stop random drops");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd add <player>" + String.valueOf(ChatColor.WHITE) + " - Add player to drop list");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd remove <player>" + String.valueOf(ChatColor.WHITE) + " - Remove player from drop list");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd playerlist" + String.valueOf(ChatColor.WHITE) + " - Show players in drop list");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd set timer <ticks>" + String.valueOf(ChatColor.WHITE) + " - Set drop interval");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd dropeggs <on/off>" + String.valueOf(ChatColor.WHITE) + " - Toggle spawn eggs");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd mode <normal/stacks/line>" + String.valueOf(ChatColor.WHITE) + " - Set drop mode");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rd drops <number>" + String.valueOf(ChatColor.WHITE) + " - Set drops per interval");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Arrays.asList("start", "stop", "add", "remove", "playerlist", "set", "dropeggs", "mode", "drops"));
        } else if (args.length == 2) {
            String subCommand;
            switch (subCommand = args[0].toLowerCase()) {
                case "add": 
                case "remove": {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        completions.add(player.getName());
                    }
                    break;
                }
                case "set": {
                    completions.add("timer");
                    break;
                }
                case "dropeggs": {
                    completions.addAll(Arrays.asList("on", "off"));
                    break;
                }
                case "mode": {
                    completions.addAll(Arrays.asList("normal", "stacks", "line"));
                }
            }
        }
        return completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).toList();
    }
}

