/*
 * Decompiled with CFR 0.152.
 */
package com.example.randomdrops.managers;

import com.example.randomdrops.RandomDropsPlugin;
import com.example.randomdrops.managers.ConfigManager;
import com.example.randomdrops.managers.ItemManager;
import com.example.randomdrops.managers.PlayerManager;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class DropScheduler {
    private final RandomDropsPlugin plugin;
    private final PlayerManager playerManager;
    private final ItemManager itemManager;
    private final ConfigManager configManager;
    private BukkitTask dropTask;
    private boolean running = false;

    public DropScheduler(RandomDropsPlugin plugin, PlayerManager playerManager, ItemManager itemManager, ConfigManager configManager) {
        this.plugin = plugin;
        this.playerManager = playerManager;
        this.itemManager = itemManager;
        this.configManager = configManager;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.scheduleDropTask();
        this.plugin.getLogger().info("Drop scheduler started");
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (this.dropTask != null) {
            this.dropTask.cancel();
            this.dropTask = null;
        }
        this.plugin.getLogger().info("Drop scheduler stopped");
    }

    public void updateInterval() {
        if (this.running) {
            this.stop();
            this.start();
        }
    }

    private void scheduleDropTask() {
        int interval = this.configManager.getDropInterval();
        this.dropTask = new BukkitRunnable(){

            public void run() {
                if (!DropScheduler.this.running) {
                    this.cancel();
                    return;
                }
                DropScheduler.this.performDrops();
            }
        }.runTaskTimer((Plugin)this.plugin, (long)interval, (long)interval);
    }

    private void performDrops() {
        List<Player> onlinePlayers = this.playerManager.getOnlineDropPlayers();
        if (onlinePlayers.isEmpty()) {
            return;
        }
        int dropsPerInterval = this.configManager.getDropsPerInterval();
        for (Player player : onlinePlayers) {
            List<ItemStack> items = this.itemManager.getRandomItems(dropsPerInterval);
            for (ItemStack item : items) {
                if (player.getInventory().firstEmpty() != -1) {
                    player.getInventory().addItem(new ItemStack[]{item});
                    continue;
                }
                player.getWorld().dropItemNaturally(player.getLocation(), item);
            }
            if (dropsPerInterval == 1) {
                player.sendMessage("\u00a7aYou received: \u00a7f" + items.get(0).getAmount() + "x " + this.formatMaterialName(items.get(0).getType()));
                continue;
            }
            player.sendMessage("\u00a7aYou received \u00a7f" + dropsPerInterval + "\u00a7a random items!");
        }
    }

    private String formatMaterialName(Material material) {
        String name = material.name().toLowerCase().replace("_", " ");
        String[] words = name.split(" ");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            formatted.append(word.substring(0, 1).toUpperCase()).append(word.substring(1));
        }
        return formatted.toString();
    }

    public boolean isRunning() {
        return this.running;
    }
}

