/*
 * Decompiled with CFR 0.152.
 */
package com.example.randomdrops.managers;

import com.example.randomdrops.RandomDropsPlugin;
import com.example.randomdrops.enums.DropMode;
import com.example.randomdrops.managers.ConfigManager;
import com.example.randomdrops.managers.ItemManager;
import com.example.randomdrops.managers.PlayerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class DropScheduler {
    private final RandomDropsPlugin plugin;
    private final PlayerManager playerManager;
    private final ItemManager itemManager;
    private final ConfigManager configManager;
    private BukkitTask dropTask;
    private boolean running = false;

    public DropScheduler(RandomDropsPlugin plugin, PlayerManager playerManager, ItemManager itemManager, ConfigManager configManager) {
        this.plugin = plugin;
        this.playerManager = playerManager;
        this.itemManager = itemManager;
        this.configManager = configManager;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.scheduleDropTask();
        this.plugin.getLogger().info("Drop scheduler started");
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (this.dropTask != null) {
            this.dropTask.cancel();
            this.dropTask = null;
        }
        this.plugin.getLogger().info("Drop scheduler stopped");
    }

    public void updateInterval() {
        if (this.running) {
            this.stop();
            this.start();
        }
    }

    private void scheduleDropTask() {
        int interval = this.configManager.getDropInterval();
        this.dropTask = new BukkitRunnable(){

            public void run() {
                if (!DropScheduler.this.running) {
                    this.cancel();
                    return;
                }
                DropScheduler.this.performDrops();
            }
        }.runTaskTimer((Plugin)this.plugin, (long)interval, (long)interval);
    }

    private void performDrops() {
        List<Player> onlinePlayers = this.playerManager.getOnlineDropPlayers();
        if (onlinePlayers.isEmpty()) {
            return;
        }
        int dropsPerInterval = this.configManager.getDropsPerInterval();
        DropMode mode = this.configManager.getDropMode();
        boolean sendFeedback = this.configManager.isSendItemFeedback();
        boolean everyoneSame = this.configManager.isEveryoneSame();
        List<ItemStack> baseItems = everyoneSame ? this.itemManager.getRandomItems(dropsPerInterval) : null;
        for (Player player : onlinePlayers) {
            List<ItemStack> items = everyoneSame && baseItems != null ? this.cloneItems(baseItems) : this.itemManager.getRandomItems(dropsPerInterval);
            this.giveItemsToPlayer(player, items, mode);
            if (!sendFeedback) continue;
            if (dropsPerInterval == 1) {
                player.sendMessage("\u00a7aYou received: \u00a7f" + items.get(0).getAmount() + "x " + this.formatMaterialName(items.get(0).getType()));
                continue;
            }
            player.sendMessage("\u00a7aYou received \u00a7f" + dropsPerInterval + "\u00a7a random items!");
        }
    }

    private void giveItemsToPlayer(Player player, List<ItemStack> items, DropMode mode) {
        if (mode == DropMode.LINE) {
            if (items.size() != 1) {
                items = Collections.singletonList(items.get(0));
            }
            ItemStack item = items.get(0);
            Material material = item.getType();
            int maxStack = material.getMaxStackSize();
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = new ItemStack(material, maxStack);
                this.addToInventoryOrDrop(player, stack);
            }
        } else if (mode == DropMode.STACKS) {
            for (ItemStack item : items) {
                item.setAmount(item.getMaxStackSize());
                this.addToInventoryOrDrop(player, item);
            }
        } else {
            for (ItemStack item : items) {
                this.addToInventoryOrDrop(player, item);
            }
        }
    }

    private void addToInventoryOrDrop(Player player, ItemStack item) {
        if (player.getInventory().firstEmpty() != -1) {
            player.getInventory().addItem(new ItemStack[]{item});
        } else {
            player.getWorld().dropItemNaturally(player.getLocation(), item);
        }
    }

    private List<ItemStack> cloneItems(List<ItemStack> items) {
        ArrayList<ItemStack> clones = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            clones.add(item.clone());
        }
        return clones;
    }

    private String formatMaterialName(Material material) {
        String name = material.name().toLowerCase().replace("_", " ");
        String[] words = name.split(" ");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
        }
        return formatted.toString();
    }

    public boolean isRunning() {
        return this.running;
    }
}

