/*
 * Decompiled with CFR 0.152.
 */
package com.example.randomdrops.managers;

import com.example.randomdrops.RandomDropsPlugin;
import com.example.randomdrops.enums.DropMode;
import com.example.randomdrops.managers.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemManager {
    private final RandomDropsPlugin plugin;
    private final ConfigManager configManager;
    private final List<Material> itemPool;
    private final Random random;
    private static final Set<Material> ALWAYS_INCLUDED_EGGS = Set.of(Material.TURTLE_EGG, Material.SNIFFER_EGG, Material.CHICKEN_SPAWN_EGG);

    public ItemManager(RandomDropsPlugin plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.itemPool = new ArrayList<Material>();
        this.random = new Random();
        this.updateItemPool();
    }

    public void updateItemPool() {
        this.itemPool.clear();
        boolean includeAllEggs = this.configManager.isDropEggs();
        for (Material material : Material.values()) {
            if (!this.shouldIncludeMaterial(material, includeAllEggs)) continue;
            this.itemPool.add(material);
        }
        this.plugin.getLogger().info("Updated item pool with " + this.itemPool.size() + " items");
    }

    private boolean shouldIncludeMaterial(Material material, boolean includeAllEggs) {
        if (material == Material.AIR || material.name().startsWith("LEGACY_")) {
            return false;
        }
        if (ALWAYS_INCLUDED_EGGS.contains(material)) {
            return true;
        }
        if (material.name().endsWith("_SPAWN_EGG")) {
            return includeAllEggs;
        }
        if (this.isProblematicItem(material)) {
            return false;
        }
        return material.isItem();
    }

    private boolean isProblematicItem(Material material) {
        return material.name().contains("COMMAND_BLOCK") || material.name().contains("STRUCTURE_BLOCK") || material.name().contains("JIGSAW") || material == Material.DEBUG_STICK || material == Material.KNOWLEDGE_BOOK;
    }

    public ItemStack getRandomItem() {
        if (this.itemPool.isEmpty()) {
            return new ItemStack(Material.DIRT);
        }
        Material randomMaterial = this.itemPool.get(this.random.nextInt(this.itemPool.size()));
        return this.createItemStack(randomMaterial);
    }

    private ItemStack createItemStack(Material material) {
        DropMode mode = this.configManager.getDropMode();
        int amount = 1;
        switch (mode) {
            case STACKS: {
                amount = Math.min(64, material.getMaxStackSize());
                break;
            }
            case LINE: {
                amount = Math.min(576, material.getMaxStackSize() * 9);
                break;
            }
            default: {
                amount = 1;
            }
        }
        return new ItemStack(material, amount);
    }

    public List<ItemStack> getRandomItems(int count) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < count; ++i) {
            items.add(this.getRandomItem());
        }
        return items;
    }

    public int getItemPoolSize() {
        return this.itemPool.size();
    }
}

