/*
 * Decompiled with CFR 0.152.
 */
package com.example.randomdrops;

import com.example.randomdrops.commands.RandomDropsCommand;
import com.example.randomdrops.managers.ConfigManager;
import com.example.randomdrops.managers.DropScheduler;
import com.example.randomdrops.managers.ItemManager;
import com.example.randomdrops.managers.PlayerManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.java.JavaPlugin;

public class RandomDropsPlugin
extends JavaPlugin {
    private static RandomDropsPlugin instance;
    private PlayerManager playerManager;
    private ItemManager itemManager;
    private DropScheduler dropScheduler;
    private ConfigManager configManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfig();
        this.playerManager = new PlayerManager(this);
        this.itemManager = new ItemManager(this, this.configManager);
        this.dropScheduler = new DropScheduler(this, this.playerManager, this.itemManager, this.configManager);
        this.getCommand("rd").setExecutor((CommandExecutor)new RandomDropsCommand(this, this.playerManager, this.dropScheduler, this.configManager, this.itemManager));
        this.playerManager.loadPlayers();
        this.getLogger().info("Random Item Drops plugin has been enabled!");
    }

    public void onDisable() {
        if (this.dropScheduler != null) {
            this.dropScheduler.stop();
        }
        if (this.playerManager != null) {
            this.playerManager.savePlayers();
        }
        if (this.configManager != null) {
            this.configManager.saveConfig();
        }
        this.getLogger().info("Random Item Drops plugin has been disabled!");
    }

    public static RandomDropsPlugin getInstance() {
        return instance;
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public DropScheduler getDropScheduler() {
        return this.dropScheduler;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

