/*
 * Decompiled with CFR 0.152.
 */
package com.example.randomdrops.enums;

import java.util.Random;

public enum LuckDupeChance {
    MASSIVE(new double[]{0.0, 25.0, 15.0, 10.0, 5.0, 4.0, 2.5, 2.0, 1.0, 0.5}),
    HUGE(new double[]{0.0, 20.0, 12.0, 7.0, 5.0, 3.0, 2.0, 1.5, 1.0, 0.5}),
    LARGE(new double[]{0.0, 14.0, 10.0, 6.0, 4.0, 2.5, 1.5, 1.0, 0.7, 0.3}),
    BIG(new double[]{0.0, 10.0, 7.0, 4.0, 3.0, 2.0, 1.0, 0.7, 0.5, 0.3}),
    NORMAL(new double[]{0.0, 8.0, 5.0, 2.5, 1.3, 1.0, 0.6, 0.3, 0.2, 0.1}),
    SMALL(new double[]{0.0, 6.0, 3.0, 1.8, 1.2, 0.9, 0.5, 0.3, 0.2, 0.1}),
    TINY(new double[]{0.0, 4.0, 2.0, 0.9, 0.6, 0.4, 0.25, 0.15, 0.1, 0.05}),
    MICRO(new double[]{0.0, 2.0, 0.8, 0.4, 0.3, 0.2, 0.15, 0.09, 0.05, 0.01});

    private final double[] chances;
    private static final Random random;

    private LuckDupeChance(double[] chances) {
        this.chances = chances;
    }

    public int calculateDupeMultiplier() {
        double roll = random.nextDouble() * 100.0;
        double cumulative = 0.0;
        for (int i = 1; i < this.chances.length; ++i) {
            if (!(roll <= (cumulative += this.chances[i]))) continue;
            return i + 1;
        }
        return 1;
    }

    public String getChancesDisplay() {
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a76").append(this.name().toLowerCase()).append(" chances:\n");
        for (int i = 1; i < this.chances.length; ++i) {
            if (!(this.chances[i] > 0.0)) continue;
            sb.append("\u00a77").append(i + 1).append("\u00d7: \u00a7f").append(this.chances[i]).append("%\n");
        }
        return sb.toString().trim();
    }

    static {
        random = new Random();
    }
}

