/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer_chainable_visual;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.xiyu.yee.onekeyminer.Onekeyminer;

@Mod.EventBusSubscriber(modid="onekeyminer_chainable_visual", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    private static final ForgeConfigSpec.BooleanValue SHOW_MINING;
    private static final ForgeConfigSpec.BooleanValue SHOW_INTERACT;
    private static final ForgeConfigSpec.BooleanValue OUTLINE_MODE;
    private static final ForgeConfigSpec.BooleanValue SHOW_THROUGH;
    private static final ForgeConfigSpec.DoubleValue LINE_ALPHA;
    private static final ForgeConfigSpec.DoubleValue HATCH_SPACING;
    private static final ForgeConfigSpec.BooleanValue SHEARING_ENABLE;
    private static final ForgeConfigSpec.DoubleValue SHEARING_RANGE;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Double>> COLOR_MINING_CFG;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Double>> COLOR_INTERACT_CFG;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Double>> COLOR_SHEARING_CFG;
    private static final ForgeConfigSpec.BooleanValue USE_CUSTOM_RENDER_TYPES;
    public static boolean showMining;
    public static boolean showInteraction;
    public static boolean outlineMode;
    public static boolean showThroughWalls;
    public static double lineAlpha;
    public static double hatchSpacing;
    public static boolean shearingEnable;
    public static double shearingRange;
    public static boolean useCustomRenderTypes;
    public static float[] colorMining;
    public static float[] colorInteract;
    public static float[] colorShearing;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SPEC) {
            Config.sync();
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            Config.sync();
        }
    }

    public static void saveConfig(ModConfig.Type spec) {
        try {
            Method saveMethod;
            Path configPath = Config.getConfigPath();
            File configFile = configPath.toFile();
            boolean saved = false;
            Object errorMessage = "";
            try {
                saveMethod = spec.getClass().getMethod("save", File.class);
                saveMethod.invoke((Object)spec, configFile);
                saved = true;
            }
            catch (Exception e1) {
                errorMessage = (String)errorMessage + "\u65b9\u6cd51\u5931\u8d25: " + e1.getMessage() + "; ";
            }
            if (!saved) {
                try {
                    saveMethod = spec.getClass().getMethod("save", new Class[0]);
                    saveMethod.invoke((Object)spec, new Object[0]);
                    saved = true;
                }
                catch (Exception e2) {
                    errorMessage = (String)errorMessage + "\u65b9\u6cd52\u5931\u8d25: " + e2.getMessage() + "; ";
                }
            }
            if (!saved) {
                try {
                    saveMethod = spec.getClass().getMethod("saveToFile", File.class);
                    saveMethod.invoke((Object)spec, configFile);
                    saved = true;
                }
                catch (Exception e3) {
                    errorMessage = (String)errorMessage + "\u65b9\u6cd53\u5931\u8d25: " + e3.getMessage() + "; ";
                }
            }
            if (!saved) {
                throw new RuntimeException("\u65e0\u6cd5\u4fdd\u5b58\u914d\u7f6e: " + (String)errorMessage);
            }
            Onekeyminer.LOGGER.info("\u914d\u7f6e\u5df2\u6210\u529f\u4fdd\u5b58\u5230: {}", (Object)configPath);
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u4fdd\u5b58\u914d\u7f6e\u65f6\u53d1\u751f\u6700\u7ec8\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get().resolve("onekeyminer-common.toml");
    }

    private static void sync() {
        showMining = (Boolean)SHOW_MINING.get();
        showInteraction = (Boolean)SHOW_INTERACT.get();
        outlineMode = (Boolean)OUTLINE_MODE.get();
        showThroughWalls = (Boolean)SHOW_THROUGH.get();
        lineAlpha = (Double)LINE_ALPHA.get();
        hatchSpacing = (Double)HATCH_SPACING.get();
        shearingEnable = (Boolean)SHEARING_ENABLE.get();
        shearingRange = (Double)SHEARING_RANGE.get();
        useCustomRenderTypes = (Boolean)USE_CUSTOM_RENDER_TYPES.get();
        Config.loadColorArray((List)COLOR_MINING_CFG.get(), colorMining);
        Config.loadColorArray((List)COLOR_INTERACT_CFG.get(), colorInteract);
        Config.loadColorArray((List)COLOR_SHEARING_CFG.get(), colorShearing);
    }

    private static void loadColorArray(List<? extends Double> list, float[] target) {
        if (list.size() >= 4) {
            for (int i = 0; i < 4; ++i) {
                double v = list.get(i);
                target[i] = (float)Math.max(0.0, Math.min(1.0, v));
            }
        }
    }

    public static float[] getMiningColor() {
        return (float[])colorMining.clone();
    }

    public static float[] getInteractionColor() {
        return (float[])colorInteract.clone();
    }

    public static float[] getShearingColor() {
        return (float[])colorShearing.clone();
    }

    public static boolean isShowMining() {
        return showMining;
    }

    public static boolean isShowInteraction() {
        return showInteraction;
    }

    public static boolean isOutlineMode() {
        return outlineMode;
    }

    public static boolean isShowThroughWalls() {
        return showThroughWalls;
    }

    public static double getLineAlpha() {
        return lineAlpha;
    }

    public static double getHatchSpacing() {
        return hatchSpacing;
    }

    public static boolean isShearingEnabled() {
        return shearingEnable;
    }

    public static double getShearingRange() {
        return shearingRange;
    }

    public static boolean useCustomRenderTypes() {
        return useCustomRenderTypes;
    }

    static {
        BUILDER.comment("Display Settings - Control what chain highlights are shown").push("display");
        SHOW_MINING = BUILDER.comment("Show mining chain block positions as highlighted outlines").translation("text.autoconfig.onekeyminer_chainable_visual.option.showMining").define("showMining", true);
        SHOW_INTERACT = BUILDER.comment("Show interaction chain block positions as highlighted outlines").translation("text.autoconfig.onekeyminer_chainable_visual.option.showInteraction").define("showInteraction", true);
        OUTLINE_MODE = BUILDER.comment("If enabled: render thick outlines. If disabled: render thin wireframes").translation("text.autoconfig.onekeyminer_chainable_visual.option.outlineMode").define("outlineMode", false);
        SHOW_THROUGH = BUILDER.comment("Render outlines through blocks (X-ray vision)").translation("text.autoconfig.onekeyminer_chainable_visual.option.showThroughWalls").define("showThroughWalls", true);
        LINE_ALPHA = BUILDER.comment("Multiplier for line transparency (0.0 = invisible, 1.0 = opaque)").translation("text.autoconfig.onekeyminer_chainable_visual.option.lineAlpha").defineInRange("lineAlpha", 1.0, 0.0, 1.0);
        HATCH_SPACING = BUILDER.comment("Spacing between hatch lines in block units").translation("text.autoconfig.onekeyminer_chainable_visual.option.hatchSpacing").defineInRange("hatchSpacing", 0.25, 0.05, 1.0);
        SHEARING_ENABLE = BUILDER.comment("Enable glowing highlight for sheep when holding shears").translation("text.autoconfig.onekeyminer_chainable_visual.option.shearingEnable").define("shearingEnable", true);
        SHEARING_RANGE = BUILDER.comment("Search radius around player for highlighting chain-shearing sheep").translation("text.autoconfig.onekeyminer_chainable_visual.option.shearingRange").defineInRange("shearingRange", 48.0, 4.0, 128.0);
        BUILDER.pop();
        BUILDER.comment("Color Settings - Configure highlight colors with RGBA values (0.0-1.0)").push("colors");
        COLOR_MINING_CFG = BUILDER.comment(new String[]{"RGBA color for mining chain highlights", "Format: [R, G, B, A]"}).translation("text.autoconfig.onekeyminer_chainable_visual.option.colorMining").defineList("colorMining", List.of(Double.valueOf(0.0), Double.valueOf(1.0), Double.valueOf(0.0), Double.valueOf(0.45)), o -> o instanceof Double && (Double)o >= 0.0 && (Double)o <= 1.0);
        COLOR_INTERACT_CFG = BUILDER.comment(new String[]{"RGBA color for interaction chain highlights", "Format: [R, G, B, A]"}).translation("text.autoconfig.onekeyminer_chainable_visual.option.colorInteract").defineList("colorInteract", List.of(Double.valueOf(0.0), Double.valueOf(0.5), Double.valueOf(1.0), Double.valueOf(0.45)), o -> o instanceof Double && (Double)o >= 0.0 && (Double)o <= 1.0);
        COLOR_SHEARING_CFG = BUILDER.comment(new String[]{"RGBA color for sheep glow effect", "Format: [R, G, B, A]"}).translation("text.autoconfig.onekeyminer_chainable_visual.option.colorShearing").defineList("colorShearing", List.of(Double.valueOf(1.0), Double.valueOf(1.0), Double.valueOf(1.0), Double.valueOf(1.0)), o -> o instanceof Double && (Double)o >= 0.0 && (Double)o <= 1.0);
        BUILDER.pop();
        BUILDER.comment("Advanced Settings - Technical rendering options").push("advanced");
        USE_CUSTOM_RENDER_TYPES = BUILDER.comment(new String[]{"Enable custom rendering pipelines for better visual effects", "Disable if experiencing rendering issues"}).translation("text.autoconfig.onekeyminer_chainable_visual.option.useCustomRenderTypes").define("useCustomRenderTypes", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
        colorMining = new float[]{0.0f, 1.0f, 0.0f, 0.45f};
        colorInteract = new float[]{0.0f, 0.5f, 1.0f, 0.45f};
        colorShearing = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    }
}

