/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer_chainable_visual.client;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.api.ChainPositionStore;
import org.xiyu.yee.onekeyminer.network.ChainModePacket;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;
import org.xiyu.yee.onekeyminer_chainable_visual.Config;
import org.xiyu.yee.onekeyminer_chainable_visual.client.KeyBindings;

@Mod.EventBusSubscriber(modid="onekeyminer_chainable_visual")
public class ClientRenderHandler {
    private static final float[] COLOR_MINING = new float[]{0.0f, 1.0f, 0.0f, 0.45f};
    private static final float[] COLOR_INTERACT = new float[]{0.0f, 0.5f, 1.0f, 0.45f};
    private static final Set<UUID> LAST_GLOWING_SHEEP = new HashSet<UUID>();
    private static RenderType LINES_NORMAL = null;
    private static RenderType LINES_TRANSPARENT = null;
    private static RenderPipeline TRANSPARENT_LINES_PIPELINE = null;
    private static boolean PIPELINE_INIT_ATTEMPTED = false;
    private static BlockPos lastTargetPos = null;
    private static final long REQUEST_THROTTLE_MS = 250L;
    private static long lastRequestTime = 0L;

    private static void ensureRenderTypes() {
        try {
            boolean useCustom = false;
            try {
                useCustom = Config.useCustomRenderTypes();
            }
            catch (Throwable ignored) {
                useCustom = false;
            }
            if (!useCustom) {
                LINES_NORMAL = RenderType.lines();
                LINES_TRANSPARENT = RenderType.lines();
                return;
            }
            if (LINES_NORMAL != null && LINES_TRANSPARENT != null) {
                return;
            }
            String MATRICES_SNIPPET = "MATRICES_FOG_SNIPPET";
            Field matricesFogField = RenderPipelines.class.getDeclaredField("MATRICES_FOG_SNIPPET");
            matricesFogField.setAccessible(true);
            Object matricesSnippet = matricesFogField.get(null);
            LINES_NORMAL = RenderType.lines();
            if (!PIPELINE_INIT_ATTEMPTED) {
                PIPELINE_INIT_ATTEMPTED = true;
                try {
                    Method registerMethod = RenderPipelines.class.getDeclaredMethod("register", RenderPipeline.class);
                    registerMethod.setAccessible(true);
                    RenderPipeline pipeline = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{(RenderPipeline.Snippet)matricesSnippet}).withVertexShader("core/rendertype_lines").withFragmentShader("core/rendertype_lines").withBlend(BlendFunction.TRANSLUCENT).withCull(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.DEBUG_LINES).withLocation("pipeline/transparent_lines").build();
                    TRANSPARENT_LINES_PIPELINE = (RenderPipeline)registerMethod.invoke(null, pipeline);
                    LINES_TRANSPARENT = RenderType.create((String)"lines_transparent", (int)1536, (RenderPipeline)TRANSPARENT_LINES_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setLineState(RenderStateShard.DEFAULT_LINE).setLayeringState(RenderType.NO_LAYERING).setOutputState(RenderType.ITEM_ENTITY_TARGET).createCompositeState(false));
                }
                catch (Throwable pipelineError) {
                    Onekeyminer.LOGGER.warn("Failed to register TRANSPARENT_LINES_PIPELINE (1.21.7), falling back to RenderType.lines(): {}", (Object)pipelineError.toString());
                    TRANSPARENT_LINES_PIPELINE = null;
                    LINES_TRANSPARENT = RenderType.lines();
                }
            } else {
                LINES_TRANSPARENT = TRANSPARENT_LINES_PIPELINE != null ? RenderType.create((String)"lines_transparent", (int)1536, (RenderPipeline)TRANSPARENT_LINES_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setLineState(RenderStateShard.DEFAULT_LINE).setLayeringState(RenderType.NO_LAYERING).setOutputState(RenderType.ITEM_ENTITY_TARGET).createCompositeState(false)) : RenderType.lines();
            }
        }
        catch (Throwable t) {
            Onekeyminer.LOGGER.warn("ensureRenderTypes failed (1.21.7), falling back to RenderType.lines(): {}", (Object)t.toString());
            LINES_NORMAL = RenderType.lines();
            LINES_TRANSPARENT = RenderType.lines();
        }
    }

    @SubscribeEvent
    public static void onRenderHighlight(RenderHighlightEvent.Block event) {
        PoseStack poseStack = event.getPoseStack();
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.gameRenderer == null || mc.player == null) {
            return;
        }
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        Vec3 camPos = mc.gameRenderer.getMainCamera().getPosition();
        String playerUuid = mc.player.getUUID().toString();
        List mining = ChainPositionStore.getMiningPositions((String)playerUuid);
        List interact = ChainPositionStore.getInteractionPositions((String)playerUuid);
        boolean configShowMining = Config.isShowMining();
        boolean configShowInteract = Config.isShowInteraction();
        boolean isInteractionKeyPressed = KeyBindings.isShowInteractionKeyPressed();
        boolean configShowThroughWalls = Config.isShowThroughWalls();
        boolean configOutlineMode = Config.isOutlineMode();
        boolean showMining = configShowMining && !isInteractionKeyPressed;
        boolean showInteract = configShowInteract && isInteractionKeyPressed;
        float[] miningColor = Config.getMiningColor();
        float[] interactColor = Config.getInteractionColor();
        poseStack.pushPose();
        poseStack.translate(-camPos.x, -camPos.y, -camPos.z);
        ClientRenderHandler.tryRequestRecomputeIfNeeded(mc);
        try {
            ClientRenderHandler.ensureRenderTypes();
            if (showMining) {
                ClientRenderHandler.renderBoxes(poseStack, bufferSource, mining, miningColor, configOutlineMode, configShowThroughWalls);
            }
            if (showInteract) {
                ClientRenderHandler.renderBoxes(poseStack, bufferSource, interact, interactColor, configOutlineMode, configShowThroughWalls);
            }
            ClientRenderHandler.renderSheepHighlight(poseStack, bufferSource, mc, playerUuid, camPos, configShowThroughWalls);
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.warn("Failed to render visual highlights: {}", (Object)e.toString());
        }
        poseStack.popPose();
        try {
            bufferSource.endBatch();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void renderBoxes(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, List<BlockPos> positions, float[] color, boolean outlineMode, boolean showThroughWalls) {
        if (positions == null || positions.isEmpty()) {
            return;
        }
        VoxelShape mergedShape = Shapes.empty();
        for (BlockPos pos : positions) {
            AABB blockAabb = new AABB(pos).inflate(0.002);
            mergedShape = Shapes.joinUnoptimized((VoxelShape)mergedShape, (VoxelShape)Shapes.create((AABB)blockAabb), (BooleanOp)BooleanOp.OR);
        }
        if (mergedShape.isEmpty()) {
            return;
        }
        PoseStack.Pose pose = poseStack.last();
        Matrix4f modelMatrix = pose.pose();
        RenderType normalType = LINES_NORMAL == null ? RenderType.lines() : LINES_NORMAL;
        RenderType transparentType = LINES_TRANSPARENT == null ? RenderType.lines() : LINES_TRANSPARENT;
        RenderType selectedType = showThroughWalls ? transparentType : normalType;
        try {
            VertexConsumer lineConsumer = bufferSource.getBuffer(selectedType);
            mergedShape.forAllEdges((x1, y1, z1, x2, y2, z2) -> {
                try {
                    if (showThroughWalls) {
                        double dx = x2 - x1;
                        double dy = y2 - y1;
                        double dz = z2 - z1;
                        double mag = Math.sqrt(dx * dx + dy * dy + dz * dz);
                        if (mag > 1.0E-4) {
                            double invMag = 1.0 / mag;
                            float nx = (float)(dx * invMag);
                            float ny = (float)(dy * invMag);
                            float nz = (float)(dz * invMag);
                            ClientRenderHandler.addLineVertexWithNormal(lineConsumer, modelMatrix, pose, x1, y1, z1, color, nx, ny, nz);
                            ClientRenderHandler.addLineVertexWithNormal(lineConsumer, modelMatrix, pose, x2, y2, z2, color, nx, ny, nz);
                        }
                    } else {
                        ClientRenderHandler.addLineVertex(lineConsumer, modelMatrix, pose, x1, y1, z1, color);
                        ClientRenderHandler.addLineVertex(lineConsumer, modelMatrix, pose, x2, y2, z2, color);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            bufferSource.endBatch(selectedType);
        }
        catch (Exception e) {
            try {
                Onekeyminer.LOGGER.warn("Failed to render lines: {}", (Object)e.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!showThroughWalls && outlineMode) {
            try {
                VertexConsumer contrastConsumer = bufferSource.getBuffer(transparentType);
                float[] contrastColor = new float[]{color[0], color[1], color[2], color[3] * 0.3f};
                mergedShape.forAllEdges((x1, y1, z1, x2, y2, z2) -> {
                    try {
                        ClientRenderHandler.addLineVertex(contrastConsumer, modelMatrix, pose, x1, y1, z1, contrastColor);
                        ClientRenderHandler.addLineVertex(contrastConsumer, modelMatrix, pose, x2, y2, z2, contrastColor);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                bufferSource.endBatch(transparentType);
            }
            catch (Exception e) {
                try {
                    Onekeyminer.LOGGER.warn("Failed to render contrast lines: {}", (Object)e.toString());
                }
                catch (Throwable contrastColor) {
                    // empty catch block
                }
            }
        }
        if (outlineMode) {
            try {
                VertexConsumer outlineConsumer = bufferSource.getBuffer(normalType);
                float outlineAlpha = color[3] * 0.6f;
                float[] outlineColor = new float[]{color[0], color[1], color[2], outlineAlpha};
                for (double offset : new double[]{-0.01, 0.01}) {
                    try {
                        VoxelShape outlineShape = Shapes.empty();
                        for (AABB aabb : mergedShape.toAabbs()) {
                            AABB outlineAabb = aabb.inflate(offset);
                            outlineShape = Shapes.joinUnoptimized((VoxelShape)outlineShape, (VoxelShape)Shapes.create((AABB)outlineAabb), (BooleanOp)BooleanOp.OR);
                        }
                        outlineShape.forAllEdges((x1, y1, z1, x2, y2, z2) -> {
                            try {
                                ClientRenderHandler.addLineVertex(outlineConsumer, modelMatrix, pose, x1, y1, z1, outlineColor);
                                ClientRenderHandler.addLineVertex(outlineConsumer, modelMatrix, pose, x2, y2, z2, outlineColor);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        });
                        bufferSource.endBatch(normalType);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                try {
                    Onekeyminer.LOGGER.warn("Failed to render outline: {}", (Object)e.toString());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static void addLineVertex(VertexConsumer vc, Matrix4f matrix, PoseStack.Pose pose, double x, double y, double z, float[] color) {
        try {
            if (vc != null && pose != null && color != null && color.length >= 4) {
                vc.addVertex(pose, (float)x, (float)y, (float)z).setColor(color[0], color[1], color[2], color[3]).setNormal(pose, 0.0f, 1.0f, 0.0f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addLineVertexWithNormal(VertexConsumer vc, Matrix4f matrix, PoseStack.Pose pose, double x, double y, double z, float[] color, float nx, float ny, float nz) {
        try {
            if (vc != null && pose != null && color != null && color.length >= 4) {
                vc.addVertex(pose, (float)x, (float)y, (float)z).setColor(color[0], color[1], color[2], color[3]).setNormal(pose, nx, ny, nz);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addQuad(VertexConsumer vc, Matrix4f matrix, PoseStack.Pose pose, float x1, float y1, float z1, float x2, float y2, float z2, float nx, float ny, float nz, float[] color, float alpha) {
        vc.addVertex(matrix, x1, y1, z1).setColor(color[0], color[1], color[2], alpha).setNormal(pose, nx, ny, nz);
        vc.addVertex(matrix, x2, y1, z1).setColor(color[0], color[1], color[2], alpha).setNormal(pose, nx, ny, nz);
        vc.addVertex(matrix, x2, y2, z2).setColor(color[0], color[1], color[2], alpha).setNormal(pose, nx, ny, nz);
        vc.addVertex(matrix, x1, y2, z2).setColor(color[0], color[1], color[2], alpha).setNormal(pose, nx, ny, nz);
    }

    private static float[] toFloatColor(double[] src, float[] fallback) {
        if (src == null || src.length < 4) {
            return fallback;
        }
        float[] out = new float[4];
        try {
            out[0] = (float)src[0];
            out[1] = (float)src[1];
            out[2] = (float)src[2];
            out[3] = (float)src[3];
        }
        catch (Exception e) {
            return fallback;
        }
        return out;
    }

    private static void tryRequestRecomputeIfNeeded(Minecraft mc) {
        if (mc == null || mc.player == null) {
            return;
        }
        String uuid = mc.player.getUUID().toString();
        if (!ChainPositionStore.isChainModeActive((String)uuid)) {
            lastTargetPos = null;
            return;
        }
        HitResult hitResult = mc.hitResult;
        BlockPos currentTarget = null;
        if (hitResult != null && hitResult.getType() == HitResult.Type.BLOCK) {
            currentTarget = ((BlockHitResult)hitResult).getBlockPos();
        }
        long now = System.currentTimeMillis();
        if (!Objects.equals(currentTarget, lastTargetPos) && now - lastRequestTime >= 250L) {
            lastRequestTime = now;
            lastTargetPos = currentTarget;
            try {
                ChainModePacket packet = new ChainModePacket(true);
                NetworkHandler.sendToServer((IOneKeyPacket)packet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void renderSheepHighlight(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, Minecraft mc, String playerUuid, Vec3 camPos, boolean showThroughWalls) {
        try {
            List shearingUuids;
            EntityHitResult ehr;
            if (!Config.isShearingEnabled()) {
                LAST_GLOWING_SHEEP.clear();
                return;
            }
            ItemStack mainHand = mc.player.getMainHandItem();
            ItemStack offHand = mc.player.getOffhandItem();
            if (!mainHand.is(Items.SHEARS) && !offHand.is(Items.SHEARS)) {
                LAST_GLOWING_SHEEP.clear();
                return;
            }
            boolean chainModeEnabled = false;
            try {
                chainModeEnabled = ChainPositionStore.isChainModeActive((String)playerUuid);
            }
            catch (Throwable t) {
                LAST_GLOWING_SHEEP.clear();
                return;
            }
            if (!chainModeEnabled) {
                LAST_GLOWING_SHEEP.clear();
                return;
            }
            HitResult hitResult = mc.hitResult;
            if (!(hitResult instanceof EntityHitResult) || !((ehr = (EntityHitResult)hitResult).getEntity() instanceof Sheep)) {
                LAST_GLOWING_SHEEP.clear();
                return;
            }
            try {
                shearingUuids = ChainPositionStore.getShearingEntityUuids((String)playerUuid);
            }
            catch (Throwable t) {
                LAST_GLOWING_SHEEP.clear();
                return;
            }
            if (shearingUuids == null || shearingUuids.isEmpty()) {
                LAST_GLOWING_SHEEP.clear();
                return;
            }
            double range = Config.getShearingRange();
            List allSheep = mc.level.getEntitiesOfClass(Sheep.class, mc.player.getBoundingBox().inflate(range));
            if (allSheep.isEmpty()) {
                LAST_GLOWING_SHEEP.clear();
                return;
            }
            HashSet<UUID> currentGlowingSheep = new HashSet<UUID>();
            ArrayList<AABB> sheepBoxes = new ArrayList<AABB>();
            for (Sheep sheep : allSheep) {
                if (!shearingUuids.contains(sheep.getUUID()) || !sheep.isAlive() || !sheep.readyForShearing()) continue;
                currentGlowingSheep.add(sheep.getUUID());
                AABB sheepBox = sheep.getBoundingBox().inflate(0.1);
                sheepBoxes.add(sheepBox);
            }
            LAST_GLOWING_SHEEP.clear();
            LAST_GLOWING_SHEEP.addAll(currentGlowingSheep);
            if (sheepBoxes.isEmpty()) {
                return;
            }
            float[] shearingColor = Config.getShearingColor();
            ClientRenderHandler.renderSheepOutlines(poseStack, bufferSource, sheepBoxes, shearingColor, showThroughWalls);
        }
        catch (Exception e) {
            try {
                Onekeyminer.LOGGER.warn("Failed to render sheep highlight: {}", (Object)e.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void renderSheepOutlines(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, List<AABB> sheepBoxes, float[] color, boolean showThroughWalls) {
        try {
            ClientRenderHandler.ensureRenderTypes();
            PoseStack.Pose pose = poseStack.last();
            Matrix4f modelMatrix = pose.pose();
            RenderType normalType = LINES_NORMAL == null ? RenderType.lines() : LINES_NORMAL;
            RenderType transparentType = LINES_TRANSPARENT == null ? RenderType.lines() : LINES_TRANSPARENT;
            RenderType selectedType = showThroughWalls ? transparentType : normalType;
            VertexConsumer lineConsumer = bufferSource.getBuffer(selectedType);
            for (AABB box : sheepBoxes) {
                ClientRenderHandler.renderAABBOutline(lineConsumer, pose, box, color);
            }
            bufferSource.endBatch(selectedType);
        }
        catch (Exception e) {
            try {
                Onekeyminer.LOGGER.warn("Failed to render sheep outlines: {}", (Object)e.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void renderAABBOutline(VertexConsumer consumer, PoseStack.Pose pose, AABB box, float[] color) {
        float minX = (float)box.minX;
        float minY = (float)box.minY;
        float minZ = (float)box.minZ;
        float maxX = (float)box.maxX;
        float maxY = (float)box.maxY;
        float maxZ = (float)box.maxZ;
        ClientRenderHandler.addLine(consumer, pose, minX, minY, minZ, maxX, minY, minZ, color);
        ClientRenderHandler.addLine(consumer, pose, maxX, minY, minZ, maxX, minY, maxZ, color);
        ClientRenderHandler.addLine(consumer, pose, maxX, minY, maxZ, minX, minY, maxZ, color);
        ClientRenderHandler.addLine(consumer, pose, minX, minY, maxZ, minX, minY, minZ, color);
        ClientRenderHandler.addLine(consumer, pose, minX, maxY, minZ, maxX, maxY, minZ, color);
        ClientRenderHandler.addLine(consumer, pose, maxX, maxY, minZ, maxX, maxY, maxZ, color);
        ClientRenderHandler.addLine(consumer, pose, maxX, maxY, maxZ, minX, maxY, maxZ, color);
        ClientRenderHandler.addLine(consumer, pose, minX, maxY, maxZ, minX, maxY, minZ, color);
        ClientRenderHandler.addLine(consumer, pose, minX, minY, minZ, minX, maxY, minZ, color);
        ClientRenderHandler.addLine(consumer, pose, maxX, minY, minZ, maxX, maxY, minZ, color);
        ClientRenderHandler.addLine(consumer, pose, maxX, minY, maxZ, maxX, maxY, maxZ, color);
        ClientRenderHandler.addLine(consumer, pose, minX, minY, maxZ, minX, maxY, maxZ, color);
    }

    private static void addLine(VertexConsumer consumer, PoseStack.Pose pose, float x1, float y1, float z1, float x2, float y2, float z2, float[] color) {
        try {
            consumer.addVertex(pose, x1, y1, z1).setColor(color[0], color[1], color[2], color[3]).setNormal(pose, 0.0f, 1.0f, 0.0f);
            consumer.addVertex(pose, x2, y2, z2).setColor(color[0], color[1], color[2], color[3]).setNormal(pose, 0.0f, 1.0f, 0.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

