/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer_chainable_visual.client;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import net.minecraftforge.fml.config.ModConfig;
import org.xiyu.yee.onekeyminer_chainable_visual.Config;

public class ModernConfigScreen
extends Screen {
    private final Screen parent;
    private final List<Object> configWidgets = new ArrayList<Object>();
    private boolean tempShowMining;
    private boolean tempShowInteraction;
    private boolean tempOutlineMode;
    private boolean tempShowThroughWalls;
    private boolean tempShearingEnable;
    private boolean tempUseCustomRenderTypes;
    private double tempLineAlpha;
    private double tempHatchSpacing;
    private final float[] tempColorMining = new float[4];
    private final float[] tempColorInteract = new float[4];
    private final float[] tempColorShearing = new float[4];
    private int currentCategory = 0;
    private Button categoryDisplayBtn;
    private Button categoryColorsBtn;
    private Button categoryAdvancedBtn;

    public ModernConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.title"));
        this.parent = parent;
        this.loadTempValues();
    }

    private void loadTempValues() {
        this.tempShowMining = Config.isShowMining();
        this.tempShowInteraction = Config.isShowInteraction();
        this.tempOutlineMode = Config.isOutlineMode();
        this.tempShowThroughWalls = Config.isShowThroughWalls();
        this.tempShearingEnable = Config.isShearingEnabled();
        this.tempUseCustomRenderTypes = Config.useCustomRenderTypes();
        this.tempLineAlpha = Config.getLineAlpha();
        this.tempHatchSpacing = Config.getHatchSpacing();
        System.arraycopy(Config.getMiningColor(), 0, this.tempColorMining, 0, 4);
        System.arraycopy(Config.getInteractionColor(), 0, this.tempColorInteract, 0, 4);
        System.arraycopy(Config.getShearingColor(), 0, this.tempColorShearing, 0, 4);
    }

    protected void init() {
        super.init();
        this.configWidgets.clear();
        int centerX = this.width / 2;
        this.categoryDisplayBtn = new ExtendedButton(centerX - 120, 25, 80, 20, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.category.display"), btn -> this.switchCategory(0));
        this.categoryColorsBtn = new ExtendedButton(centerX - 40, 25, 80, 20, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.category.colors"), btn -> this.switchCategory(1));
        this.categoryAdvancedBtn = new ExtendedButton(centerX + 40, 25, 80, 20, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.category.advanced"), btn -> this.switchCategory(2));
        this.addRenderableWidget((GuiEventListener)this.categoryDisplayBtn);
        this.addRenderableWidget((GuiEventListener)this.categoryColorsBtn);
        this.addRenderableWidget((GuiEventListener)this.categoryAdvancedBtn);
        this.setupConfigWidgets();
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(centerX - 100, this.height - 35, 95, 20, (Component)Component.translatable((String)"gui.done"), btn -> this.saveAndClose()));
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(centerX + 5, this.height - 35, 95, 20, (Component)Component.translatable((String)"gui.cancel"), btn -> this.onClose()));
    }

    private void switchCategory(int category) {
        if (this.currentCategory != category) {
            this.currentCategory = category;
            this.clearConfigWidgets();
            this.setupConfigWidgets();
        }
    }

    private void clearConfigWidgets() {
        this.configWidgets.forEach(widget -> {
            if (widget instanceof Button) {
                Button btn = (Button)widget;
                this.removeWidget((GuiEventListener)btn);
            } else if (widget instanceof ForgeSlider) {
                ForgeSlider slider = (ForgeSlider)widget;
                this.removeWidget((GuiEventListener)slider);
            } else if (widget instanceof EditBox) {
                EditBox edit = (EditBox)widget;
                this.removeWidget((GuiEventListener)edit);
            }
        });
        this.configWidgets.clear();
    }

    private void setupConfigWidgets() {
        this.updateCategoryButtons();
        int centerX = this.width / 2;
        int startY = 60;
        int itemHeight = 25;
        switch (this.currentCategory) {
            case 0: {
                this.setupDisplayCategory(centerX, startY, itemHeight);
                break;
            }
            case 1: {
                this.setupColorCategory(centerX, startY, itemHeight);
                break;
            }
            case 2: {
                this.setupAdvancedCategory(centerX, startY, itemHeight);
            }
        }
    }

    private void updateCategoryButtons() {
        this.categoryDisplayBtn.active = this.currentCategory != 0;
        this.categoryColorsBtn.active = this.currentCategory != 1;
        this.categoryAdvancedBtn.active = this.currentCategory != 2;
    }

    private void setupDisplayCategory(int centerX, int startY, int itemHeight) {
        int y = startY;
        this.addCheckbox(centerX - 150, y, 300, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.option.showMining"), this.tempShowMining, val -> {
            this.tempShowMining = val;
        });
        this.addCheckbox(centerX - 150, y += itemHeight, 300, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.option.showInteraction"), this.tempShowInteraction, val -> {
            this.tempShowInteraction = val;
        });
        this.addCheckbox(centerX - 150, y += itemHeight, 300, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.option.shearingEnable"), this.tempShearingEnable, val -> {
            this.tempShearingEnable = val;
        });
        this.addCheckbox(centerX - 150, y += itemHeight, 300, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.option.outlineMode"), this.tempOutlineMode, val -> {
            this.tempOutlineMode = val;
        });
        this.addCheckbox(centerX - 150, y += itemHeight, 300, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.option.showThroughWalls"), this.tempShowThroughWalls, val -> {
            this.tempShowThroughWalls = val;
        });
        this.addSlider(centerX - 150, y += itemHeight + 5, 300, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.option.lineAlpha"), this.tempLineAlpha, 0.0, 1.0, val -> {
            this.tempLineAlpha = val;
        });
        this.addSlider(centerX - 150, y += itemHeight, 300, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.option.hatchSpacing"), this.tempHatchSpacing, 0.05, 1.0, val -> {
            this.tempHatchSpacing = val;
        });
    }

    private void setupColorCategory(int centerX, int startY, int itemHeight) {
        int y = startY;
        int colorHeight = 45;
        this.addColorPicker(centerX - 150, y, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.option.colorMining"), this.tempColorMining);
        this.addColorPicker(centerX - 150, y += colorHeight, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.option.colorInteract"), this.tempColorInteract);
        this.addColorPicker(centerX - 150, y += colorHeight, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.option.colorShearing"), this.tempColorShearing);
    }

    private void setupAdvancedCategory(int centerX, int startY, int itemHeight) {
        int y = startY;
        this.addCheckbox(centerX - 150, y, 300, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.option.useCustomRenderTypes"), this.tempUseCustomRenderTypes, val -> {
            this.tempUseCustomRenderTypes = val;
        });
    }

    private void addCheckbox(int x, int y, int width, Component text, boolean initialValue, Consumer<Boolean> onChange) {
        ExtendedButton button = new ExtendedButton(x, y, width, 20, (Component)text.copy().append(": " + (initialValue ? "ON" : "OFF")), btn -> {
            boolean newValue = !btn.getMessage().getString().endsWith("ON");
            onChange.accept(newValue);
            btn.setMessage((Component)text.copy().append(": " + (newValue ? "ON" : "OFF")));
        });
        this.configWidgets.add(button);
        this.addRenderableWidget((GuiEventListener)button);
    }

    private void addSlider(int x, int y, int width, Component text, double initialValue, double min, double max, final Consumer<Double> onChange) {
        ForgeSlider slider = new ForgeSlider(this, x, y, width, 20, text, (Component)Component.empty(), min, max, initialValue, false){

            protected void applyValue() {
                super.applyValue();
                onChange.accept(this.getValue());
            }
        };
        this.configWidgets.add(slider);
        this.addRenderableWidget((GuiEventListener)slider);
    }

    private void addColorPicker(int x, int y, Component label, final float[] color) {
        ExtendedButton colorPreview = new ExtendedButton(this, x, y + 20, 40, 20, (Component)Component.empty(), btn -> {}){

            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
                int bgColor = 0xFF000000 | (int)(color[0] * 255.0f) << 16 | (int)(color[1] * 255.0f) << 8 | (int)(color[2] * 255.0f);
                graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, bgColor);
                graphics.hLine(this.getX(), this.getX() + this.width - 1, this.getY(), -1);
                graphics.hLine(this.getX(), this.getX() + this.width - 1, this.getY() + this.height - 1, -1);
                graphics.vLine(this.getX(), this.getY(), this.getY() + this.height - 1, -1);
                graphics.vLine(this.getX() + this.width - 1, this.getY(), this.getY() + this.height - 1, -1);
            }
        };
        this.addRenderableWidget((GuiEventListener)colorPreview);
        this.configWidgets.add(colorPreview);
        String[] labels = new String[]{"R", "G", "B", "A"};
        for (int i = 0; i < 4; ++i) {
            int index = i;
            EditBox editBox = new EditBox(this.font, x + 50 + i * 55, y + 20, 50, 20, (Component)Component.literal((String)labels[i]));
            editBox.setValue(String.format("%.2f", Float.valueOf(color[i])));
            editBox.setResponder(text -> {
                try {
                    float value;
                    color[index] = value = Math.max(0.0f, Math.min(1.0f, Float.parseFloat(text)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.addRenderableWidget((GuiEventListener)editBox);
            this.configWidgets.add(editBox);
        }
    }

    private void saveAndClose() {
        Config.showMining = this.tempShowMining;
        Config.showInteraction = this.tempShowInteraction;
        Config.outlineMode = this.tempOutlineMode;
        Config.showThroughWalls = this.tempShowThroughWalls;
        Config.shearingEnable = this.tempShearingEnable;
        Config.useCustomRenderTypes = this.tempUseCustomRenderTypes;
        Config.lineAlpha = this.tempLineAlpha;
        Config.hatchSpacing = this.tempHatchSpacing;
        System.arraycopy(this.tempColorMining, 0, Config.colorMining, 0, 4);
        System.arraycopy(this.tempColorInteract, 0, Config.colorInteract, 0, 4);
        System.arraycopy(this.tempColorShearing, 0, Config.colorShearing, 0, 4);
        Config.saveConfig(ModConfig.Type.CLIENT);
        this.minecraft.setScreen(this.parent);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        String categoryTitle;
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 8, 0xFFFFFF);
        switch (this.currentCategory) {
            case 0: {
                String string = "text.autoconfig.onekeyminer_chainable_visual.category.display";
                break;
            }
            case 1: {
                String string = "text.autoconfig.onekeyminer_chainable_visual.category.colors";
                break;
            }
            case 2: {
                String string = "text.autoconfig.onekeyminer_chainable_visual.category.advanced";
                break;
            }
            default: {
                String string = categoryTitle = "";
            }
        }
        if (!categoryTitle.isEmpty()) {
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)categoryTitle), this.width / 2, 50, 0xCCCCCC);
        }
        if (this.currentCategory == 1) {
            int y = 60;
            int colorHeight = 45;
            graphics.drawString(this.font, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.option.colorMining"), this.width / 2 - 150, y, 0xFFFFFF);
            graphics.drawString(this.font, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.option.colorInteract"), this.width / 2 - 150, y += colorHeight, 0xFFFFFF);
            graphics.drawString(this.font, (Component)Component.translatable((String)"text.autoconfig.onekeyminer_chainable_visual.option.colorShearing"), this.width / 2 - 150, y += colorHeight, 0xFFFFFF);
        }
        super.render(graphics, mouseX, mouseY, partialTick);
    }
}

