/*
 * Decompiled with CFR 0.152.
 */
package com.mubioh.plexmate.settings.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mubioh.plexmate.features.clickaction.ClickActionFeature;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;

public class Config {
    private static final File FILE = new File("config/plexmate.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public ClickActionFeature.ClickMode clickMode = ClickActionFeature.ClickMode.FRIEND;
    public boolean showOwnNametag = true;
    public boolean useClansDomain = false;
    public boolean autoGG = true;
    public int autoGGCooldown = 1;
    public String selectedGame = "CakeWars";
    public boolean autoAcceptFriendRequests = false;

    public static Config load() {
        Config config;
        if (!FILE.exists()) {
            return new Config();
        }
        FileReader reader = new FileReader(FILE);
        try {
            config = (Config)GSON.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new Config();
            }
        }
        reader.close();
        return config;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

