/*
 * Decompiled with CFR 0.152.
 */
package com.carter4242.conduitblocker.listener;

import com.carter4242.conduitblocker.storage.BlockPos;
import com.carter4242.conduitblocker.storage.ConduitStore;
import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class DrownedSpawnListener
implements Listener {
    private final int chunkCheckRadius;
    private final boolean debug;
    private final long autosaveTicks;
    private final Plugin plugin;
    private final Map<UUID, Map<Long, List<BlockPos>>> chunkedConduits = new ConcurrentHashMap<UUID, Map<Long, List<BlockPos>>>();
    private final ConduitStore store;
    private BukkitTask autosaveTask;
    private int spawnsPrevented = 0;
    private final List<Period> periods = new ArrayList<Period>();
    private long lastPeriodEndTime = System.currentTimeMillis();

    public DrownedSpawnListener(Plugin plugin, ConduitStore store, int chunkCheckRadius, long autosaveTicks, boolean debug) {
        this.plugin = plugin;
        this.store = store;
        this.chunkCheckRadius = chunkCheckRadius;
        this.debug = debug;
        this.autosaveTicks = autosaveTicks;
        store.load();
        this.loadConduitsFromStore();
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        if (autosaveTicks > 0L) {
            this.autosaveTask = Bukkit.getScheduler().runTaskTimerAsynchronously(plugin, store::save, autosaveTicks, autosaveTicks);
        }
    }

    public void shutdown() {
        if (this.autosaveTask != null) {
            this.autosaveTask.cancel();
        }
        this.store.save();
        this.chunkedConduits.clear();
    }

    private void loadConduitsFromStore() {
        this.chunkedConduits.clear();
        this.store.forEachConduit((worldId, pos) -> {
            long chunkKey = pos.chunkKey();
            this.chunkedConduits.computeIfAbsent((UUID)worldId, k -> new ConcurrentHashMap()).computeIfAbsent(chunkKey, k -> new ArrayList()).add(pos);
        });
    }

    private void addConduit(World world, BlockPos position) {
        UUID worldId = world.getUID();
        this.store.add(worldId, position);
        long chunkKey = position.chunkKey();
        this.chunkedConduits.computeIfAbsent(worldId, k -> new ConcurrentHashMap()).computeIfAbsent(chunkKey, k -> new ArrayList()).add(position);
        if (this.autosaveTicks <= 0L) {
            Bukkit.getScheduler().runTaskAsynchronously(this.plugin, this.store::save);
        }
    }

    private void removeConduit(World world, BlockPos position) {
        UUID worldId = world.getUID();
        this.store.remove(worldId, position);
        long chunkKey = position.chunkKey();
        Map<Long, List<BlockPos>> worldMap = this.chunkedConduits.get(worldId);
        if (worldMap != null) {
            List<BlockPos> chunkConduits = worldMap.get(chunkKey);
            if (chunkConduits != null) {
                chunkConduits.remove(position);
                if (chunkConduits.isEmpty()) {
                    worldMap.remove(chunkKey);
                }
            }
            if (worldMap.isEmpty()) {
                this.chunkedConduits.remove(worldId);
            }
        }
        if (this.autosaveTicks <= 0L) {
            Bukkit.getScheduler().runTaskAsynchronously(this.plugin, this.store::save);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onConduitPlace(BlockPlaceEvent event) {
        if (event.getBlockPlaced().getType() != Material.CONDUIT) {
            return;
        }
        Location loc = event.getBlockPlaced().getLocation();
        this.addConduit(event.getBlockPlaced().getWorld(), new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onConduitBreak(BlockBreakEvent event) {
        if (event.getBlock().getType() != Material.CONDUIT) {
            return;
        }
        Location loc = event.getBlock().getLocation();
        this.removeConduit(event.getBlock().getWorld(), new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onDrownedPreSpawn(PreCreatureSpawnEvent event) {
        if (!this.shouldPreventSpawn(event.getType(), event.getReason())) {
            return;
        }
        Location loc = event.getSpawnLocation();
        if (this.isNearConduit(loc)) {
            event.setShouldAbortSpawn(true);
            event.setCancelled(true);
            DrownedSpawnListener drownedSpawnListener = this;
            synchronized (drownedSpawnListener) {
                ++this.spawnsPrevented;
            }
            if (this.debug) {
                Bukkit.getLogger().info(String.format("Drowned spawn prevented at [%d, %d, %d]", loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
            }
        } else if (this.debug) {
            Bukkit.getLogger().info(String.format("Drowned spawn allowed at [%d, %d, %d]", loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        }
    }

    private boolean shouldPreventSpawn(EntityType entityType, CreatureSpawnEvent.SpawnReason reason) {
        if (entityType != EntityType.DROWNED) {
            return false;
        }
        return switch (reason) {
            case CreatureSpawnEvent.SpawnReason.NATURAL, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS -> true;
            default -> false;
        };
    }

    private boolean isNearConduit(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        UUID worldId = world.getUID();
        Map<Long, List<BlockPos>> worldMap = this.chunkedConduits.get(worldId);
        if (worldMap == null || worldMap.isEmpty()) {
            return false;
        }
        int blockX = location.getBlockX();
        int blockZ = location.getBlockZ();
        int chunkX = blockX >> 4;
        int chunkZ = blockZ >> 4;
        for (int dx = -this.chunkCheckRadius; dx <= this.chunkCheckRadius; ++dx) {
            for (int dz = -this.chunkCheckRadius; dz <= this.chunkCheckRadius; ++dz) {
                long chunkKey = (long)(chunkX + dx) << 32 | (long)(chunkZ + dz) & 0xFFFFFFFFL;
                List<BlockPos> chunkConduits = worldMap.get(chunkKey);
                if (chunkConduits == null || chunkConduits.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized int getAndResetSpawnsPreventedAverage() {
        int value = this.spawnsPrevented;
        this.spawnsPrevented = 0;
        long now = System.currentTimeMillis();
        long oneHourAgo = now - 3600000L;
        this.periods.removeIf(p -> p.timestamp < oneHourAgo);
        this.periods.add(new Period(this.lastPeriodEndTime, value));
        int totalSpawns = 0;
        long start = now;
        for (Period p2 : this.periods) {
            totalSpawns += p2.count;
            if (p2.timestamp >= start) continue;
            start = p2.timestamp;
        }
        double totalMillis = now - start;
        double totalMinutes = totalMillis / 60000.0;
        double averagePerHour = totalMinutes > 0.0 ? (double)totalSpawns * 60.0 / totalMinutes : (double)totalSpawns;
        this.lastPeriodEndTime = now;
        return (int)averagePerHour;
    }

    private static class Period {
        final long timestamp;
        final int count;

        Period(long timestamp, int count) {
            this.timestamp = timestamp;
            this.count = count;
        }
    }
}

