/*
 * Decompiled with CFR 0.152.
 */
package com.carter4242.conduitblocker.storage;

import java.util.Objects;

public final class BlockPos {
    private final int x;
    private final int y;
    private final int z;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public long chunkKey() {
        return (long)(this.x >> 4) << 32 ^ (long)(this.z >> 4) & 0xFFFFFFFFL;
    }

    public int chunkX() {
        return this.x >> 4;
    }

    public int chunkZ() {
        return this.z >> 4;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockPos)) {
            return false;
        }
        BlockPos blockPos = (BlockPos)o;
        return this.x == blockPos.x && this.y == blockPos.y && this.z == blockPos.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public String toString() {
        return String.format("BlockPos{x=%d, y=%d, z=%d}", this.x, this.y, this.z);
    }
}

