/*
 * Decompiled with CFR 0.152.
 */
package com.carter4242.conduitstopper;

import com.carter4242.conduitstopper.listener.DrownedSpawnListener;
import com.carter4242.conduitstopper.storage.ConduitStore;
import java.io.File;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DrownedConduitSpawnBlocker
extends JavaPlugin {
    private DrownedSpawnListener listener;
    private ConduitStore store;

    public void onEnable() {
        this.saveDefaultConfig();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        int chunkCheckRadius = this.getConfig().getInt("chunk-check-radius", 2);
        long autosaveTicks = this.getConfig().getLong("autosave-ticks", 6000L);
        boolean debug = this.getConfig().getBoolean("debug", false);
        File conduitsFile = new File(this.getDataFolder(), "conduits.yml");
        this.store = new ConduitStore(conduitsFile, this.getLogger());
        this.listener = new DrownedSpawnListener((Plugin)this, this.store, chunkCheckRadius, autosaveTicks, debug);
        this.getLogger().info("ConduitSpawnStopper has been enabled!");
    }

    public void onDisable() {
        if (this.listener != null) {
            this.listener.shutdown();
        }
        this.getLogger().info("ConduitSpawnStopper has been disabled!");
    }
}

