/*
 * Decompiled with CFR 0.152.
 */
package com.carter4242.conduitstopper.storage;

import com.carter4242.conduitstopper.storage.BlockPos;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.bukkit.configuration.file.YamlConfiguration;

public final class ConduitStore {
    private final File file;
    private final Logger logger;
    private final Map<UUID, Set<BlockPos>> data = new HashMap<UUID, Set<BlockPos>>();
    private boolean dirty = false;

    public ConduitStore(File file, Logger logger) {
        this.file = file;
        this.logger = logger;
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
    }

    public void load() {
        this.data.clear();
        this.dirty = false;
        if (!this.file.exists()) {
            return;
        }
        try {
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)this.file);
            for (String worldKey : cfg.getKeys(false)) {
                try {
                    UUID worldId = UUID.fromString(worldKey);
                    List positions = cfg.getStringList(worldKey);
                    HashSet<BlockPos> conduitSet = new HashSet<BlockPos>();
                    for (String positionStr : positions) {
                        BlockPos pos = this.parseBlockPos(positionStr);
                        if (pos == null) continue;
                        conduitSet.add(pos);
                    }
                    if (conduitSet.isEmpty()) continue;
                    this.data.put(worldId, conduitSet);
                }
                catch (IllegalArgumentException e) {
                    this.logger.warning("Invalid world ID in conduits.yml: " + worldKey);
                }
            }
        }
        catch (Exception e) {
            this.logger.severe("Failed to load conduits.yml: " + e.getMessage());
        }
    }

    public void save() {
        if (!this.dirty) {
            return;
        }
        try {
            YamlConfiguration cfg = new YamlConfiguration();
            for (Map.Entry<UUID, Set<BlockPos>> entry : this.data.entrySet()) {
                ArrayList<CallSite> positions = new ArrayList<CallSite>(entry.getValue().size());
                for (BlockPos pos : entry.getValue()) {
                    positions.add((CallSite)((Object)(pos.getX() + "," + pos.getY() + "," + pos.getZ())));
                }
                cfg.set(entry.getKey().toString(), positions);
            }
            cfg.save(this.file);
            this.dirty = false;
        }
        catch (IOException e) {
            this.logger.severe("Failed to save conduits.yml: " + e.getMessage());
        }
    }

    public void add(UUID worldId, BlockPos position) {
        if (this.data.computeIfAbsent(worldId, k -> new HashSet()).add(position)) {
            this.dirty = true;
        }
    }

    public void remove(UUID worldId, BlockPos position) {
        Set<BlockPos> worldConduits = this.data.get(worldId);
        if (worldConduits == null) {
            return;
        }
        if (worldConduits.remove(position)) {
            this.dirty = true;
            if (worldConduits.isEmpty()) {
                this.data.remove(worldId);
            }
        }
    }

    public boolean contains(UUID worldId, BlockPos position) {
        Set<BlockPos> worldConduits = this.data.get(worldId);
        return worldConduits != null && worldConduits.contains(position);
    }

    public void forEachConduit(BiConsumer<UUID, BlockPos> consumer) {
        this.data.forEach((worldId, conduits) -> conduits.forEach(pos -> consumer.accept((UUID)worldId, (BlockPos)pos)));
    }

    public void forEachConduit(UUID worldId, Consumer<BlockPos> consumer) {
        Set<BlockPos> worldConduits = this.data.get(worldId);
        if (worldConduits != null) {
            worldConduits.forEach(consumer);
        }
    }

    private BlockPos parseBlockPos(String positionStr) {
        try {
            String[] parts = positionStr.split(",");
            if (parts.length != 3) {
                return null;
            }
            int x = Integer.parseInt(parts[0].trim());
            int y = Integer.parseInt(parts[1].trim());
            int z = Integer.parseInt(parts[2].trim());
            return new BlockPos(x, y, z);
        }
        catch (NumberFormatException e) {
            this.logger.warning("Invalid position format: " + positionStr);
            return null;
        }
    }
}

