package com.skellybuilds.servermodmenu.config.option;

import com.mojang.serialization.Codec;
import com.skellybuilds.servermodmenu.util.TranslationUtil;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_7172;

public class EnumConfigOption<E extends Enum<E>> implements OptionConvertable {
	private final String key, translationKey;
	private final Class<E> enumClass;
	private final E defaultValue;

	public EnumConfigOption(String key, E defaultValue) {
		ConfigOptionStorage.setEnum(key, defaultValue);
		this.key = key;
		this.translationKey = TranslationUtil.translationKeyOf("option", key);
		this.enumClass = defaultValue.getDeclaringClass();
		this.defaultValue = defaultValue;
	}

	public String getKey() {
		return key;
	}

	public E getValue() {
		return ConfigOptionStorage.getEnum(key, enumClass);
	}

	public void setValue(E value) {
		ConfigOptionStorage.setEnum(key, value);
	}

	public void cycleValue() {
		ConfigOptionStorage.cycleEnum(key, enumClass);
	}

	public void cycleValue(int amount) {
		ConfigOptionStorage.cycleEnum(key, enumClass, amount);
	}

	public E getDefaultValue() {
		return defaultValue;
	}

	private static <E extends Enum<E>> class_2561 getValueText(EnumConfigOption<E> option, E value) {
		return class_2561.method_43471(option.translationKey + "." + value.name().toLowerCase(Locale.ROOT));
	}

	public class_2561 getButtonText() {
		return class_5244.method_32700(class_2561.method_43471(translationKey), getValueText(this, getValue()));
	}

	@Override
	public class_7172<E> asOption() {
		return new class_7172<>(translationKey, class_7172.method_42399(),
				(text, value) -> getValueText(this, value),
				new class_7172.class_7173<>(Arrays.asList(enumClass.getEnumConstants()),
						Codec.STRING.xmap(
								string -> Arrays.stream(enumClass.getEnumConstants()).filter(e -> e.name().toLowerCase().equals(string)).findAny().orElse(null),
								newValue -> newValue.name().toLowerCase()
						)),
				getValue(), value -> ConfigOptionStorage.setEnum(key, value));
	}
}
