package com.skellybuilds.servermodmenu.gui;

import com.google.common.base.Joiner;

import com.mojang.blaze3d.systems.RenderSystem;
import com.skellybuilds.servermodmenu.config.ModMenuConfig;
import com.skellybuilds.servermodmenu.config.ModMenuConfigManager;
import com.skellybuilds.servermodmenu.db.SMod;
import com.skellybuilds.servermodmenu.gui.widget.ModListWidget;
import com.skellybuilds.servermodmenu.gui.widget.entries.ModListEntry;
import com.skellybuilds.servermodmenu.ModMenu;
import com.skellybuilds.servermodmenu.gui.widget.DescriptionListWidget;
import com.skellybuilds.servermodmenu.util.DrawingUtil;
import com.skellybuilds.servermodmenu.util.Networking;
import com.skellybuilds.servermodmenu.util.TranslationUtil;
import com.skellybuilds.servermodmenu.util.mod.Mod;
import com.skellybuilds.servermodmenu.util.mod.ModBadgeRenderer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_641;
import net.minecraft.class_7919;
import net.minecraft.class_8012;
import net.minecraft.client.render.*;
import net.minecraft.util.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

import static com.skellybuilds.servermodmenu.ModMenu.MainNetwork;


public class ModsScreen extends class_437 {
	private static final class_2960 FILTERS_BUTTON_LOCATION = class_2960.method_60655(ModMenu.MOD_ID, "textures/gui/filters_button.png");
	private static final class_2960 DOWNLOSD_BUTTON_LOCATION = class_2960.method_60655(ModMenu.MOD_ID, "textures/gui/download_button.png");
	private static final class_2960 RELOADS_BUTTON_LOCATION = class_2960.method_60655(ModMenu.MOD_ID, "textures/gui/reload_servers.png");
	private static final class_2561 OptModT = class_2561.method_43471("modmenu.isOpt");
	private static final class_2561 ReqModT = class_2561.method_43471("modmenu.isReq");
	private static final class_2561 TOGGLE_FILTER_OPTIONS = class_2561.method_43471("modmenu.toggleFilterOptions");
	private static final class_2561 RELOAD_ALLSERV_T = class_2561.method_43471("modmenu.reloadAllServers");
	private static final class_2561 DOWNLOADALLSERV_T = class_2561.method_43471("modmenu.downloadsAll");
	private static final class_2561 CONFIGURE = class_2561.method_43471("modmenu.configure");
	private static final Logger LOGGER = LoggerFactory.getLogger("Mod Menu | ModsScreen");
	private class_342 searchBox;
	private DescriptionListWidget descriptionListWidget;
	private final class_437 previousScreen;
	public ModListWidget modList;
	private ModListEntry selected;
	private ModBadgeRenderer modBadgeRenderer;
	private double scrollPercent = 0;
	private boolean init = false;
	private boolean filterOptionsShown = false;
	private int paneY;
	private static final int RIGHT_PANE_Y = 48;
	private int paneWidth;
	private int rightPaneX;
	private int searchBoxX;
	private int filtersX;
	private int filtersWidth;
	private int searchRowWidth;
	public final Set<String> showModChildren = new HashSet<>();
	public SMod[] ModsA = {};
	public final Map<String, Boolean> modHasConfigScreen = new HashMap<>();
	public final Map<String, Throwable> modScreenErrors = new HashMap<>();
	private class_310 client = class_310.method_1551();
	private class_641 serverList;
	public AtomicInteger amountofvmods = new AtomicInteger();
	class_4185 websiteButton;
	class_4185 issuesButton;
	class_4185 downloadAllSButton;
	class_4185 downloadButton;
	class_4185 showHiddenServers;
	class_4185 sortingButton;
	class_4185 filtersButton;
	class_4185 reloadSButton;

	public ModsScreen(class_437 previousScreen) {
		super(class_2561.method_43471("servermodmenu.title"));
		this.previousScreen = previousScreen;
	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
		if (modList.method_25405(mouseX, mouseY)) {
			return this.modList.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
		}

		if (descriptionListWidget.method_25405(mouseX, mouseY)) {
			return this.descriptionListWidget.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
		}

		return false;
	}


	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (button == 0 && selected == null) { // left click
			int textWidth = field_22793.method_27525(class_2561.method_43471("modmenu.adddamnservers"));
			int x = (this.field_22789 - textWidth) / 2;
			int y = this.field_22790 / 2;

			boolean clicked =
				mouseX >= x &&
					mouseX <= x + textWidth &&
					mouseY >= y &&
					mouseY <= y + field_22793.field_2000;

			if (clicked) {
				serverList = new class_641(field_22787);
				serverList.method_2981();
				MainNetwork.shutdown();
				ModMenu.LoadServerListConnections(serverList, MainNetwork);
				method_25419();
				class_310.method_1551().method_1507(new ModsScreen(this.previousScreen));
				return true;
			}
		}

		return super.method_25402(mouseX, mouseY, button);
	}

//	private boolean NThreadsFinished(){
//		final boolean[] isAllDone = {true};
//		MainNetwork.networkThreads.forEach((d, a) -> {
//			if(!isAllDone[0]) return;
//			if(a.getState() == Thread.State.RUNNABLE) {
//				isAllDone[0] = false;
//			}
//		});
//
//		return isAllDone[0];
//	}

	public void switchToConfirm(){
			this.field_22787.execute(() -> {
				 this.field_22787.method_1507(new ConfirmationScreen(this, this::resCB, this::backCB, class_2561.method_43470("All of your mods have finished downloading! Do you wish to close the game?")
					.method_27692(class_124.field_1056).method_27692(class_124.field_1060)));
			});

	}

	public void switchToConfirmCS(String CSText){
		this.field_22787.execute(() -> {
			this.field_22787.method_1507(new ConfirmationScreen(this, this::resCB, this::backCB, class_2561.method_43470(CSText)
				.method_27692(class_124.field_1056).method_27692(class_124.field_1060)));
		});

	}

//	@Override
//	public void tick() {
//		this.searchBox.tick();
//	}

	private void backCB(ConfirmationScreen bla){
		class_310.method_1551().method_1507(bla.prevS);
	}
	private void resCB(ConfirmationScreen bla){
		LOGGER.info("Your game didn't crash, you intentionally (or by mistake, you never know) closed the game.");
		class_310.method_1551().method_1592();
	}

	public void calcServersSize(){
		amountofvmods.set(0);
		modList.method_25396().forEach((entry) -> {
			if(entry.isFirst) {
				AtomicBoolean isHidden = new AtomicBoolean(false);
				if (!entry.renderSvnNO && ModMenu.SMODS.get(entry.serverName).size() > 1) {
					ModMenuConfig.HIDDEN_SERVERS.getValue().forEach((name) -> {
							if (Objects.equals(name, entry.serverName)) {
								isHidden.set(true);
							}
						});

					if(isHidden.get()){
						if(ModMenuConfig.SHOWHIDDENSERVERS.getValue()) amountofvmods.getAndIncrement();
					} else {
						amountofvmods.getAndIncrement();
					}
				}
			}
		});
	}

	private boolean isValidUrl(String url) {
		if (url == null || url.isEmpty()) return false;
		try {
			new java.net.URI(url.replaceAll("\"", ""));
			return true;
		} catch (Exception e) {
			return false;
		}
	}


	@Override
	protected void method_25426() {

		serverList = new class_641(field_22787);
		serverList.method_2981();

		paneY = ModMenuConfig.CONFIG_MODE.getValue() ? 48 : 48 + 19;
		paneWidth = this.field_22789 / 2 - 8;
		rightPaneX = field_22789 - paneWidth;

		int filtersButtonSize = (ModMenuConfig.CONFIG_MODE.getValue() ? 0 : 22);
		int searchWidthMax = paneWidth - 32 - filtersButtonSize;
		int searchBoxWidth = ModMenuConfig.CONFIG_MODE.getValue() ? Math.min(200, searchWidthMax) : searchWidthMax;
		searchBoxX = paneWidth / 2 - searchBoxWidth / 2 - filtersButtonSize / 2;
		this.searchBox = new class_342(this.field_22793, searchBoxX, 22, searchBoxWidth, 20, this.searchBox, class_2561.method_43471("modmenu.search"));
		this.searchBox.method_1863((string_1) -> this.modList.filter(string_1, false));

		for (Mod mod : ModMenu.MODS.values()) {
			String id = mod.getId();
			if (!modHasConfigScreen.containsKey(id)) {
				try {
					class_437 configScreen = ModMenu.getConfigScreen(id, this);
					modHasConfigScreen.put(id, configScreen != null);
				} catch (java.lang.NoClassDefFoundError e) {
					LOGGER.warn("The '" + id + "' mod config screen is not available because " + e.getLocalizedMessage() + " is missing.");
					modScreenErrors.put(id, e);
					modHasConfigScreen.put(id, false);
				} catch (Throwable e) {
					LOGGER.error("Error from mod '" + id + "'", e);
					modScreenErrors.put(id, e);
					modHasConfigScreen.put(id, false);
				}
			}
		}
		ModMenu.SMODS.forEach((d, w) -> {
			w.forEach((e, mod) -> {
				String id = mod.id;
				if (!modHasConfigScreen.containsKey(id)) {
					try {
						class_437 configScreen = ModMenu.getConfigScreen(id, this);
						modHasConfigScreen.put(id, configScreen != null);
					} catch (java.lang.NoClassDefFoundError wa) {
						LOGGER.warn("The '" + id + "' mod config screen is not available because " + wa.getLocalizedMessage() + " is missing.");
						modScreenErrors.put(id, wa);
						modHasConfigScreen.put(id, false);
					} catch (Throwable wa) {
						LOGGER.error("Error from mod '" + id + "'", wa);
						modScreenErrors.put(id, wa);
						modHasConfigScreen.put(id, false);
					}
				}
			});

			});



		this.modList = new ModListWidget(this.field_22787, this.paneWidth,
			this.field_22790 - paneY - 36,
			paneY, ModMenuConfig.COMPACT_LIST.getValue() ? 23 : 36, this.searchBox.method_1882(), this.modList, this);
		if(ModMenu.MODS.isEmpty() && !ModMenu.SMODS.isEmpty()){
			this.modList.useSMod = true;
		}
		this.modList.method_46421(0);
		modList.reloadFilters();

		// Downloads all from each server. Yep, may take time!
		downloadAllSButton =
			LegacyTexturedButtonWidget.legacyTexturedBuilder(
					class_2561.method_43473(), // or a tooltip text if you want
					button -> {

						final class_1144[] tempmgr = new class_1144[1];
						boolean change = false;
						button.field_22763 = false;
							Thread finalT = new Thread(() -> {
							AtomicBoolean isERRORD = new AtomicBoolean(false);
							AtomicBoolean isSUCONCE = new AtomicBoolean(false);
							modList.method_25396().forEach((child) -> {
								if(child.isFirst){
									EntryButton mButton = ModMenu.buttonEntries.get(child.serverName);
									mButton.active = false;
								}
							});

							modList.method_25396().forEach((child) -> {
								if(child.isFirst) {
									EntryButton mButton = ModMenu.buttonEntries.get(child.serverName);
									if (!change) {
										tempmgr[0] = mButton.SOUNDMANAGER;
									}
									child.downloadA(mButton);
									boolean isDT0 = false;
									boolean isDTFW = false;
									while (true) {
										if(MainNetwork.isDthreadDone(child.serverName, child.smod.id)){
											isDT0 = true;
										}
										if(isDT0 && !isDTFW){
											try {
												Thread.sleep(2950);
											} catch (InterruptedException e) {
												LOGGER.error("Interrupted: {}", e.toString());
											}
											if(MainNetwork.isDthreadDone(child.serverName, child.smod.id)){
												if(Objects.equals(MainNetwork.networkErrors.get(child.serverName + child.smod.id), "ERR")){
													button.field_22763 = true;
													button.field_22764 = true;
													mButton.active = true;
													mButton.visible = true;
													tempmgr[0].method_4873(class_1109.method_4758(class_3417.field_15008, 1.0F));
													isERRORD.set(true);
													break;
												} else {
													isDTFW = true;
													isSUCONCE.set(true);
												}
											} else isDT0 = false;
										} else {
											if(!isDTFW) {
												try {
													Thread.sleep(750);
												} catch (InterruptedException e) {
													LOGGER.error("Interrupted: {}", e.toString());
												}
											} else {
												break;
											}
										}
									}
									if(!isERRORD.get() && !isSUCONCE.get()) {
										mButton.visible = false;
									}
								}
							});

							// if no errors & downloaded a server sucessfully
							if(!isERRORD.get() && isSUCONCE.get()) {
								tempmgr[0].method_4873(class_1109.method_4758(class_3417.field_15195, 1.0F));
								button.field_22764 = false;
								switchToConfirm();
							} // a server downlaoded successfully but another one failed!
							else if(isERRORD.get() && isSUCONCE.get()) {
								tempmgr[0].method_4873(class_1109.method_4758(class_3417.field_14794, 1.0F));
								//button.visible = false;
								switchToConfirmCS("A server's mod successfully were downloaded but another one failed!!! Do you wish to close the game?");
							} // All servers failed to download!!!
							else if(isERRORD.get() && !isSUCONCE.get()){
								tempmgr[0].method_4873(class_1109.method_4758(class_3417.field_14904, 1.0F));
							}
						});

						finalT.start();




					}
				)
				.position(paneWidth / 2 + searchBoxWidth / 2 - 10 + 41, 22)
				.size(20, 20)
				.uv(0, 0, 20)   // (u, v, vOffset) like your old constructor
				.texture(DOWNLOSD_BUTTON_LOCATION, 32, 64)
				.build();


		downloadAllSButton.method_47400(class_7919.method_47407(DOWNLOADALLSERV_T));

		this.descriptionListWidget = new DescriptionListWidget(
			this.field_22787, this.paneWidth,
			this.field_22790 - RIGHT_PANE_Y - 96,
			RIGHT_PANE_Y + 60,
			field_22793.field_2000 + 1, this);
		this.descriptionListWidget.method_46421(rightPaneX);

		downloadButton =
			LegacyTexturedButtonWidget.legacyTexturedBuilder(
					class_2561.method_43473(),
					button -> {
						if (selected == null) return;

						if (!ModMenu.buttonEntries.get(selected.serverName).active) return;
						if (!ModMenu.buttonEntries.get(selected.serverName).visible) return;

						final String id = selected.getSMod().getId();

						if (Networking.isModAlreadyPresent(id)) {
							return;
						}

						button.field_22763 = false;

						new Thread(() -> {
							// This runs in a background thread
							MainNetwork.requestNDownload(selected.serverName, id);
							while(!MainNetwork.isDthreadDone(selected.serverName, id)) {

							}
							boolean networkError = "ERR".equals(MainNetwork.networkErrors.get(selected.serverName));

							// Update button state on the client thread
							class_310.method_1551().execute(() -> {
								if (networkError) {
									button.field_22763 = true;
									button.field_22764 = true;
								} else {
									ModMenu.idsDLD.add(selected.getSMod().id);
									selected.smod.isDownloaded = true;
									button.field_22763 = true;

									if (!ModMenu.isAllDFB) {
										boolean allHidden = ModMenu.buttonEntries.values().stream()
											.allMatch(b -> !b.visible);
										if (allHidden) ModMenu.isAllDFB = true;
									}

									// Show confirmation screen if no network error
									if (!networkError) switchToConfirm();
								}
							});
						}).start();

					}
				)
				.position(field_22789 - 24, RIGHT_PANE_Y)
				.size(20, 20)
				.uv(0, 0, 20)
				.texture(DOWNLOSD_BUTTON_LOCATION, 32, 64)
				.build();

		int urlButtonWidths = paneWidth / 2 - 2;
		int cappedButtonWidth = Math.min(urlButtonWidths, 200);
		websiteButton =
			class_4185.method_46430(
					class_2561.method_43471("modmenu.website"),
					button -> {
						if(selected.useSMOD()) {
							final SMod mod = Objects.requireNonNull(selected).getSMod();
							this.field_22787.method_1507(new class_407((bool) -> {
								if (bool) {
									class_156.method_668().method_670(mod.meta.contact.getHomepage().replaceAll("\"", ""));
								}
								this.field_22787.method_1507(this);
							}, mod.meta.contact.getHomepage().replaceAll("\"", ""), false));
						} else {
							final Mod mod = Objects.requireNonNull(selected).getMod();
							this.field_22787.method_1507(new class_407((bool) -> {
								if (bool) {
									class_156.method_668().method_670(mod.getWebsite());
								}
								this.field_22787.method_1507(this);
							}, mod.getWebsite(), false));
						}
					}
				)
				.method_46433(
					rightPaneX + (urlButtonWidths / 2) - (cappedButtonWidth / 2),
					RIGHT_PANE_Y + 36
				)
				.method_46437(Math.min(urlButtonWidths, 200), 20)
				.method_46431();


		 issuesButton =
			class_4185.method_46430(
					class_2561.method_43471("modmenu.issues"),
					button -> {
						if(selected.useSMOD()){
							if(selected.renderSvnNO){
								return;
							}
							final SMod mod = Objects.requireNonNull(selected).getSMod();
							this.field_22787.method_1507(new class_407((bool) -> {
								if (bool) {
									class_156.method_668().method_670(mod.meta.contact.getIssues().replaceAll("\"", ""));
								}
								this.field_22787.method_1507(this);
							}, mod.meta.contact.getIssues(), false));
						} else {
							final Mod mod = Objects.requireNonNull(selected).getMod();
							this.field_22787.method_1507(new class_407((bool) -> {
								if (bool) {
									class_156.method_668().method_670(mod.getIssueTracker());
								}
								this.field_22787.method_1507(this);
							}, mod.getIssueTracker(), false));
						}
					}
				)
				.method_46433(
					rightPaneX + urlButtonWidths + 4 + (urlButtonWidths / 2) - (cappedButtonWidth / 2),
					RIGHT_PANE_Y + 36
				)
				.method_46437(Math.min(urlButtonWidths, 200), 20)
				.method_46431();



		this.method_25429(this.searchBox);
		filtersButton =
			LegacyTexturedButtonWidget.legacyTexturedBuilder(
					TOGGLE_FILTER_OPTIONS,
					button -> filterOptionsShown = !filterOptionsShown
				)
				.position(
					paneWidth / 2 + searchBoxWidth / 2 - 20 / 2 + 2,
					22
				)
				.size(20, 20)
				.uv(0, 0, 20)
				.texture(FILTERS_BUTTON_LOCATION, 32, 64)
				.build();

		filtersButton.method_47400(class_7919.method_47407(TOGGLE_FILTER_OPTIONS));

		reloadSButton =
			LegacyTexturedButtonWidget.legacyTexturedBuilder(
					class_2561.method_43473(), // or your narration text if you use one
					button -> {
						button.field_22763 = false;
						serverList = new class_641(field_22787);
						serverList.method_2981();
						MainNetwork.shutdown();
						ModMenu.LoadServerListConnections(serverList, MainNetwork);
						method_25419();
						class_310.method_1551().method_1507(new ModsScreen(this.previousScreen));
						button.field_22763 = true;
//						new Thread(() -> {
//							while(true) {
//								if(MainNetwork.isNthreadsDone()){
//									this.modList.reloadFilters();
//									button.active = true;
//									break;
//								}
//							}
//							return;
//						}).start();
					}
				)
				.position(
					paneWidth / 2 + searchBoxWidth / 2 - 20 / 2 + 22,
					22
				)
				.size(20, 20)
				.uv(0, 0, 20)
				.texture(RELOADS_BUTTON_LOCATION, 32, 64)
				.build();


		reloadSButton.method_47400(class_7919.method_47407(RELOAD_ALLSERV_T));
		this.method_37063(filtersButton);
		this.method_37063(reloadSButton);
		class_2561 showLibrariesText = ModMenuConfig.SHOW_LIBRARIES.getButtonText();
		class_2561 sortingText = ModMenuConfig.SSORTING.getButtonText();
		int showLibrariesWidth = field_22793.method_27525(showLibrariesText) + 4;
		int sortingWidth = field_22793.method_27525(sortingText);
		class_2561 showHBT = ModMenuConfig.SHOWHIDDENSERVERS.getButtonText();
		filtersWidth = showLibrariesWidth + sortingWidth + 2;
		searchRowWidth = searchBoxX + searchBoxWidth + 22;
		updateFiltersX();

		sortingButton = class_4185.method_46430(
				sortingText,
				btn -> {
					ModMenuConfig.SSORTING.cycleValue();
					ModMenuConfigManager.save();
					modList.reloadFilters();
				}
			)
			.method_46433(21, 45)
			.method_46437(50, 20)
			.method_46431();

		this.method_37063(
			sortingButton
		);
		showHiddenServers = class_4185.method_46430(
				showHBT,
				btn -> {
					ModMenuConfig.SHOWHIDDENSERVERS.toggleValue();
					ModMenuConfigManager.save();
					calcServersSize();
					modList.reloadFilters();
				}
			)
			.method_46433(77, 45)
			.method_46437(field_22793.method_27525(showHBT) + 6, 20)
			.method_46431();

		this.method_37063(
			showHiddenServers
		);

		this.method_25429(this.modList);
		this.method_37063(downloadAllSButton);
		if (!ModMenuConfig.HIDE_CONFIG_BUTTONS.getValue()) {
			this.method_37063(downloadButton);
		}
		this.method_37063(websiteButton);
		this.method_37063(issuesButton);
		this.method_25429(this.descriptionListWidget);
		this.method_37063(
				class_4185.method_46430(class_5244.field_24334, button -> field_22787.method_1507(previousScreen))
						.method_46433(215, this.field_22790 - 28) //this.width / 2 + 4 - 14
						.method_46437(150, 20)
						.method_46435(Supplier::get)
						.method_46431());
		this.searchBox.method_25365(true);

		init = true;
	}

	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		return super.method_25404(keyCode, scanCode, modifiers) || this.searchBox.method_25404(keyCode, scanCode, modifiers);
	}

	@Override
	public boolean method_25400(char chr, int keyCode) {
		return this.searchBox.method_25400(chr, keyCode);
	}

	@Override
	public void method_25394(class_332 DrawContext, int mouseX, int mouseY, float delta) {
		//if(selected == null && ModsA.length > 0)updateSelectedEntry(new ModListEntry(ModsA[0], modList));
		super.method_25394(DrawContext, mouseX, mouseY, delta);

		if(selected == null){

		}

		ModListEntry selectedEntry = selected;
		if (selectedEntry != null && !selectedEntry.renderSvnNO) {
			this.descriptionListWidget.method_25394(DrawContext, mouseX, mouseY, delta);
		}
		if(selectedEntry != null && selectedEntry.useSMOD()) {
			issuesButton.field_22763 = isValidUrl(selectedEntry.smod.meta.contact.getIssues());
			websiteButton.field_22763 = isValidUrl(selectedEntry.smod.meta.contact.getHomepage());
			downloadButton.field_22763 = !Networking.isModAlreadyPresent(selectedEntry.smod.id);


		this.modList.method_25394(DrawContext, mouseX, mouseY, delta);
		this.searchBox.method_25394(DrawContext, mouseX, mouseY, delta);

//		RenderSystem.disableBlend();
		DrawContext.method_27534(this.field_22793, this.field_22785, this.modList.method_25368() / 2, 8, 0xFFFFFFFF);
//		if (!ModMenuConfig.DISABLE_DRAG_AND_DROP.getValue()) {
//			DrawContext.drawCenteredTextWithShadow(this.textRenderer, Text.translatable("modmenu.dropInfo.line1").formatted(Formatting.GRAY), this.width - this.modList.getWidth() / 2, RIGHT_PANE_Y / 2 - client.textRenderer.fontHeight - 1, 16777215);
//			DrawContext.drawCenteredTextWithShadow(this.textRenderer, Text.translatable("modmenu.dropInfo.line2").formatted(Formatting.GRAY), this.width - this.modList.getWidth() / 2, RIGHT_PANE_Y / 2 + 1, 16777215);
//		}
		if (!ModMenuConfig.CONFIG_MODE.getValue()) {



			class_2561 fullModCount = class_2561.method_43469("servermodmenu.showingMods.n", amountofvmods);
			if (!ModMenuConfig.CONFIG_MODE.getValue() && updateFiltersX()) {
				if (filterOptionsShown) {
					if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || field_22793.method_27525(fullModCount) <= filtersX - 5) {
						DrawContext.method_51430(field_22793, fullModCount.method_30937(), searchBoxX, 52, 0xFFFFFFFF, false);
					} else {
						if (selected == null) {
							DrawContext.method_51439(field_22793, class_2561.method_43471("modmenu.adddamnservers"), searchBoxX, 46, 0xFFFFFFFF, true);
						} else {
							DrawContext.method_51430(field_22793, class_2561.method_43469("servermodmenu.showingMods.n", amountofvmods).method_30937(), searchBoxX, 46, 0xFFFFFFFF, false);
							DrawContext.method_51430(field_22793, computeLibraryCountText().method_30937(), searchBoxX, 57, 0xFFFFFFFF, false);
						}
					}
				} else {
					if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || field_22793.method_27525(fullModCount) <= modList.method_25368() - 5) {
						DrawContext.method_51430(field_22793, fullModCount.method_30937(), searchBoxX, 52, 0xFFFFFF, false);
					} else {
						if (selected == null) {
							DrawContext.method_51439(field_22793, class_2561.method_43471("modmenu.adddamnservers"), searchBoxX, 46, 0xFF0000, true);
						} else {
							DrawContext.method_51430(field_22793, class_2561.method_43469("servermodmenu.showingMods.n", amountofvmods).method_30937(), searchBoxX, 46, 0xFFFFFFFF, false);
							DrawContext.method_51430(field_22793, class_2561.method_43469("servermodmenu.showingMods.n", amountofvmods).method_30937(), searchBoxX, 57, 0xFFFFFFFF, false);
						}
					}
				}
			}
		}
		if (selectedEntry != null) {
			if (selectedEntry.useSMOD()) {
				SMod smod = selectedEntry.getSMod();
				if(!selectedEntry.renderSvnNO) {
					int x = rightPaneX;
					if ("java".equals(smod.getId())) {
						DrawingUtil.drawRandomVersionBackgroundS(smod, DrawContext, x, RIGHT_PANE_Y, 32, 32);
					}
					DrawContext.method_25291(class_10799.field_56883, this.selected.getIconTexture(), x, RIGHT_PANE_Y, 0.0F, 0.0F, 32, 32, 32, 32, 0xFFFFFFFF);
					int lineSpacing = field_22793.field_2000 + 1;
					int imageOffset = 36;
					class_2561 name = class_2561.method_43470(smod.meta.name);
					class_5348 trimmedName = name;
					int maxNameWidth = this.field_22789 - (x + imageOffset);
					if (field_22793.method_27525(name) > maxNameWidth) {
						class_5348 ellipsis = class_5348.method_29430("...");
						trimmedName = class_5348.method_29433(field_22793.method_1714(name, maxNameWidth - field_22793.method_27525(ellipsis)), ellipsis);
					}
					DrawContext.method_51430(field_22793, class_2477.method_10517().method_30934(trimmedName), x + imageOffset, RIGHT_PANE_Y + 1, class_8012.field_42973, false);
					if (mouseX > x + imageOffset && mouseY > RIGHT_PANE_Y + 1 && mouseY < RIGHT_PANE_Y + 1 + field_22793.field_2000 && mouseX < x + imageOffset + field_22793.method_27525(trimmedName)) {
						DrawContext.method_71276(class_2561.method_43469("modmenu.modIdToolTip", smod.getId()), mouseX, mouseY);
					}
					if (init || modBadgeRenderer == null || modBadgeRenderer.getSMod() != smod) {
						modBadgeRenderer = new ModBadgeRenderer(x + imageOffset + this.field_22787.field_1772.method_27525(trimmedName) + 2, RIGHT_PANE_Y, field_22789 - 28, selectedEntry.smod, this);
						init = false;
					}
					if (!ModMenuConfig.HIDE_BADGES.getValue()) {
						if (!selected.useSMOD()) modBadgeRenderer.draw(DrawContext, mouseX, mouseY);
					}

					DrawContext.method_51433(field_22793, smod.getVersion(), x + imageOffset, RIGHT_PANE_Y + 2 + lineSpacing, 0xFFAAAAAA, false);
					if(smod.isOptional){
						DrawContext.method_51439(field_22793, OptModT, x + imageOffset, RIGHT_PANE_Y + 10 + lineSpacing, 0xFFAAAAAA, false);
					} else {
						DrawContext.method_51439(field_22793, ReqModT, x + imageOffset, RIGHT_PANE_Y + 10 + lineSpacing, 0xFFAAAAAA, false);
					}


					String authors;
					List<String> names = Arrays.asList(smod.meta.authors);

					if (!names.isEmpty()) {
						if (names.size() > 1) {
							authors = Joiner.on(", ").join(names);
						} else {
							authors = names.get(0);
						}
						DrawingUtil.drawWrappedString(DrawContext, class_1074.method_4662("modmenu.authorPrefix", authors), x + imageOffset, RIGHT_PANE_Y + 2 + lineSpacing * 2, paneWidth - imageOffset - 4, 1, 0xFFAAAAAA);
					}
				}
			} else {
				Mod mod = selectedEntry.getMod();
				int x = rightPaneX;
				if ("java".equals(mod.getId())) {
					DrawingUtil.drawRandomVersionBackground(mod, DrawContext, x, RIGHT_PANE_Y, 32, 32);
				}
				DrawContext.method_25291(class_10799.field_56883, this.selected.getIconTexture(), x, RIGHT_PANE_Y, 0.0F, 0.0F, 32, 32, 32, 32, 0xFFFFFFFF);
				int lineSpacing = field_22793.field_2000 + 1;
				int imageOffset = 36;
				class_2561 name = class_2561.method_43470(mod.getTranslatedName());
				class_5348 trimmedName = name;
				int maxNameWidth = this.field_22789 - (x + imageOffset);
				if (field_22793.method_27525(name) > maxNameWidth) {
					class_5348 ellipsis = class_5348.method_29430("...");
					trimmedName = class_5348.method_29433(field_22793.method_1714(name, maxNameWidth - field_22793.method_27525(ellipsis)), ellipsis);
				}
				DrawContext.method_51430(field_22793, class_2477.method_10517().method_30934(trimmedName), x + imageOffset, RIGHT_PANE_Y + 1, 0xFFFFFFFF, false);
				if (mouseX > x + imageOffset && mouseY > RIGHT_PANE_Y + 1 && mouseY < RIGHT_PANE_Y + 1 + field_22793.field_2000 && mouseX < x + imageOffset + field_22793.method_27525(trimmedName)) {
					DrawContext.method_71276(class_2561.method_43469("modmenu.modIdToolTip", mod.getId()), mouseX, mouseY);
				}
				if (init || modBadgeRenderer == null || modBadgeRenderer.getMod() != mod) {
					modBadgeRenderer = new ModBadgeRenderer(x + imageOffset + this.field_22787.field_1772.method_27525(trimmedName) + 2, RIGHT_PANE_Y, field_22789 - 28, selectedEntry.mod, this);
					init = false;
				}
				if (!ModMenuConfig.HIDE_BADGES.getValue()) {
					modBadgeRenderer.draw(DrawContext, mouseX, mouseY);
				}
				if (mod.isReal()) {
					DrawContext.method_51433(field_22793, mod.getPrefixedVersion(), x + imageOffset, RIGHT_PANE_Y + 2 + lineSpacing, 0xFFAAAAAA, false);
				}
				String authors;
				List<String> names = mod.getAuthors();

				if (!names.isEmpty()) {
					if (names.size() > 1) {
						authors = Joiner.on(", ").join(names);
					} else {
						authors = names.get(0);
					}
					DrawingUtil.drawWrappedString(DrawContext, class_1074.method_4662("modmenu.authorPrefix", authors), x + imageOffset, RIGHT_PANE_Y + 2 + lineSpacing * 2, paneWidth - imageOffset - 4, 1, 0xFFAAAAAA);
				}
			}
		}

//			super.render(DrawContext, mouseX, mouseY, delta);
		} else {
			showHiddenServers.field_22764 = false;
			sortingButton.field_22764 = false;
			websiteButton.field_22764 = false;
			issuesButton.field_22764 = false;
			filtersButton.field_22764 = false;
			reloadSButton.field_22764 = false;
			downloadAllSButton.field_22764 = false;
			downloadButton.field_22764 = false;

			class_2561 txt = class_2561.method_43471("modmenu.adddamnservers");
			int textWidth = field_22793.method_27525(txt);
			int x = (this.field_22789 - textWidth) / 2;
			int y = this.field_22790 / 2;

			DrawContext.method_51439(field_22793, txt, x, y, 0xFFFF0000, true);
			boolean hovering =
				mouseX >= x &&
					mouseX <= x + textWidth &&
					mouseY >= y &&
					mouseY <= y + field_22793.field_2000;
			if (hovering) {
				DrawContext.method_71276(class_2561.method_43471("modmenu.adddamnservers.tooltip"), mouseX, mouseY);
			}

		}
	}

//	private Text computeModCountText(boolean includeLibs) {
//		int davin = ModMenu.SMODS.values().size();
//
//		//int[] rootMods = formatModCount(davin.stream().map((mmod) -> mmod.).collect(Collectors.toSet()));
//
//		if(davin < 1){
//			return Text.translatable("modmenu.adddamnservers");
//		}
//
//		if (includeLibs && ModMenuConfig.SHOW_LIBRARIES.getValue()) {
//			//int[] rootLibs = formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains(Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
//			return TranslationUtil.
//		} else {
//			return TranslationUtil.translateNumeric("modmenu.showingMods", rootMods);
//		}
//	}

	private class_2561 computeLibraryCountText() {
		if (ModMenuConfig.SHOW_LIBRARIES.getValue()) {
			int[] rootLibs = formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains(Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));

			if(rootLibs.length < 1){
				return class_2561.method_43471("modmenu.adddamnservers");
			}
			return TranslationUtil.translateNumeric("modmenu.showingLibraries", rootLibs);
		} else {
			return class_2561.method_43470(null);
		}
	}

	private int[] formatModCount(Set<String> set) {
		int visible = modList.getDisplayedCountFor(set);
		int total = set.size();
		if (visible == total) {
			return new int[]{total};
		}
		return new int[]{visible, total};
	}

	@Override
	public void method_25419() {
		this.modList.close();
		this.field_22787.method_1507(this.previousScreen);
	}

	public ModListEntry getSelectedEntry() {
		return selected;
	}

	public void updateSelectedEntry(ModListEntry entry) {
		if (entry != null) {
			this.selected = entry;
		}

	}

	public double getScrollPercent() {
		return scrollPercent;
	}

	public void updateScrollPercent(double scrollPercent) {
		this.scrollPercent = scrollPercent;
	}

	public String getSearchInput() {
		return searchBox.method_1882();
	}

	private boolean updateFiltersX() {
		if ((filtersWidth + field_22793.method_27525(class_2561.method_43469("servermodmenu.showingMods.n", ModMenu.SMODS.values().size())) + 20) >= searchRowWidth && ((filtersWidth + field_22793.method_27525(class_2561.method_43469("servermodmenu.showingMods.n", ModMenu.SMODS.values().size())) + 20) >= searchRowWidth || (filtersWidth + field_22793.method_27525(computeLibraryCountText()) + 20) >= searchRowWidth)) {
			filtersX = paneWidth / 2 - filtersWidth / 2;
			return !filterOptionsShown;
		} else {
			filtersX = searchRowWidth - filtersWidth + 1;
			return true;
		}
	}

	private static boolean isFabricMod(Path mod) {
		try (JarFile jarFile = new JarFile(mod.toFile())) {
			return jarFile.getEntry("fabric.mod.json") != null;
		} catch (IOException e) {
			return false;
		}
	}

	public Map<String, Boolean> getModHasConfigScreen() {
		return modHasConfigScreen;
	}
}
