package com.skellybuilds.servermodmenu.gui.widget;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.skellybuilds.servermodmenu.config.ModMenuConfig;
import com.skellybuilds.servermodmenu.db.SMod;
import com.skellybuilds.servermodmenu.gui.ModsScreen;
import com.skellybuilds.servermodmenu.gui.widget.entries.ModListEntry;
import com.skellybuilds.servermodmenu.util.VersionUtil;
import com.skellybuilds.servermodmenu.util.mod.Mod;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4265;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8219;
import net.minecraft.client.render.*;
import java.util.*;

public class DescriptionListWidget extends class_350<DescriptionListWidget.DescriptionEntry> {

	private static final class_2561 HAS_UPDATE_TEXT = class_2561.method_43471("modmenu.hasUpdate");
	private static final class_2561 EXPERIMENTAL_TEXT = class_2561.method_43471("modmenu.experimental").method_27692(class_124.field_1065);
	private static final class_2561 MODRINTH_TEXT = class_2561.method_43471("modmenu.modrinth");
	private static final class_2561 CHILD_HAS_UPDATE_TEXT = class_2561.method_43471("modmenu.childHasUpdate");
	private static final class_2561 LINKS_TEXT = class_2561.method_43471("modmenu.links");
	private static final class_2561 SOURCE_TEXT = class_2561.method_43471("modmenu.source").method_27692(class_124.field_1078).method_27692(class_124.field_1073);
	private static final class_2561 LICENSE_TEXT = class_2561.method_43471("modmenu.license");
	private static final class_2561 VIEW_CREDITS_TEXT = class_2561.method_43471("modmenu.viewCredits").method_27692(class_124.field_1078).method_27692(class_124.field_1073);
	private static final class_2561 CREDITS_TEXT = class_2561.method_43471("modmenu.credits");

	private final ModsScreen parent;
	private final class_327 textRenderer;
	private ModListEntry lastSelected = null;

	public DescriptionListWidget(class_310 client, int width,
								 int height,
								 int y,
								 int itemHeight, ModsScreen parent) {
		super(client, width, height, y, itemHeight);
		this.parent = parent;
		this.textRenderer = client.field_1772;
	}

	@Override
	public DescriptionEntry method_25334() {
		return null;
	}

	@Override
	public int method_25322() {
		return this.field_22758 - 10;
	}

	@Override
	protected int method_65507() {
		return this.field_22758 - 6 + this.method_46426();
	}

	@Override
	public void method_47399(class_6382 builder) {
		Mod mod = parent.getSelectedEntry().getMod();
		if (mod == null) return;
		builder.method_37033(class_6381.field_33788, mod.getTranslatedName() + " " + mod.getPrefixedVersion());
	}

	private void rebuildUI() {

		ModListEntry selectedEntry = parent.getSelectedEntry();
		if (selectedEntry == null) {
			return;
		}
		if (selectedEntry != lastSelected) {
			lastSelected = selectedEntry;
			method_25339();
			method_44382(-Double.MAX_VALUE);
			if (lastSelected != null) {
				DescriptionEntry emptyEntry = new DescriptionEntry(class_5481.field_26385);
				int wrapWidth = method_25322() - 5;
				String description;

				if(lastSelected.useSMOD()) {
					SMod smod = lastSelected.getSMod();
					if(!lastSelected.renderSvnNO) {

						description = smod.meta.baseDesc;
						if (!description.isEmpty()) {
							for (class_5481 line : textRenderer.method_1728(class_2561.method_43470(description.replaceAll("\n", "\n\n")), wrapWidth)) {
								method_25396().add(new DescriptionEntry(line));
							}
						}

						Map<String, String> links = smod.meta.links.getLinks();
						String sourceLink = smod.meta.links.getLink("sources");


						if ((!links.isEmpty() || sourceLink != null) && !ModMenuConfig.HIDE_MOD_LINKS.getValue()) {
							if (!Objects.equals(links.get("modmenu.links"), "{}")) {
								method_25396().add(emptyEntry);

								for (class_5481 line : textRenderer.method_1728(LINKS_TEXT, wrapWidth)) {
									method_25396().add(new DescriptionEntry(line));
								}

								if (sourceLink != null) {
									int indent = 8;
									for (class_5481 line : textRenderer.method_1728(SOURCE_TEXT, wrapWidth - 16)) {
										method_25396().add(new LinkEntry(line, sourceLink, indent));
										indent = 16;
									}
								}


								links.forEach((key, value) -> {
									int indent = 8;
									Gson gson = new Gson();
									JsonObject jsonObject = gson.fromJson(value, JsonObject.class);

										for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
											for (class_5481 line : textRenderer.method_1728(class_2561.method_43471(entry.getKey()).method_27692(class_124.field_1078).method_27692(class_124.field_1073), wrapWidth - 16)) {
												method_25396().add(new LinkEntry(line, entry.getValue().getAsString(), indent));
												indent = 16;
											}
										}
								});
							}
//						// later
//						Set<String> licenses = mod.getLicense();
//						if (!ModMenuConfig.HIDE_MOD_LICENSE.getValue() && !licenses.isEmpty()) {
//							children().add(emptyEntry);
//
//							for (OrderedText line : textRenderer.wrapLines(LICENSE_TEXT, wrapWidth)) {
//								children().add(new DescriptionEntry(line));
//							}
//
//							for (String license : licenses) {
//								int indent = 8;
//								for (OrderedText line : textRenderer.wrapLines(Text.literal(license), wrapWidth - 16)) {
//									children().add(new DescriptionEntry(line, indent));
//									indent = 16;
//								}
//							}
//						}

							if (!ModMenuConfig.HIDE_MOD_CREDITS.getValue()) {
								if ("minecraft".equals(smod.getId())) {
									method_25396().add(emptyEntry);

									for (class_5481 line : textRenderer.method_1728(VIEW_CREDITS_TEXT, wrapWidth)) {
										method_25396().add(new MojangCreditsEntry(line));
									}
								} else if (!"java".equals(smod.getId())) {
									String[] mergedArray = new String[smod.meta.authors.length + smod.meta.contributers.length];
									System.arraycopy(smod.meta.authors, 0, mergedArray, 0, smod.meta.authors.length);
									System.arraycopy(smod.meta.contributers, 0, mergedArray, smod.meta.authors.length, smod.meta.contributers.length);

									List<String> credits = Arrays.asList(mergedArray);
									//credits.
									if (!credits.isEmpty()) {
										method_25396().add(emptyEntry);

										for (class_5481 line : textRenderer.method_1728(CREDITS_TEXT, wrapWidth)) {
											method_25396().add(new DescriptionEntry(line));
										}

										for (String credit : credits) {
											int indent = 8;
											for (class_5481 line : textRenderer.method_1728(class_2561.method_43470(credit), wrapWidth - 16)) {
												method_25396().add(new DescriptionEntry(line, indent));
												indent = 16;
											}
										}
									}
								}
							}
						}
					} else {
						return;
					}
				} else {
					Mod mod = lastSelected.getMod();
					description = mod.getTranslatedDescription();
					if (!description.isEmpty()) {
						for (class_5481 line : textRenderer.method_1728(class_2561.method_43470(description.replaceAll("\n", "\n\n")), wrapWidth)) {
							method_25396().add(new DescriptionEntry(line));
						}
					}


//				if (ModMenuConfig.UPDATE_CHECKER.getValue() && !ModMenuConfig.DISABLE_UPDATE_CHECKER.getValue().contains(mod.getId())) {
//					if (mod.getModrinthData() != null) {
//						children().add(emptyEntry);
//
//						int index = 0;
//						for (OrderedText line : textRenderer.wrapLines(HAS_UPDATE_TEXT, wrapWidth - 11)) {
//							DescriptionEntry entry = new DescriptionEntry(line);
//							if (index == 0) entry.setUpdateTextEntry();
//
//							children().add(entry);
//							index += 1;
//						}
//
//						for (OrderedText line : textRenderer.wrapLines(EXPERIMENTAL_TEXT, wrapWidth - 16)) {
//							children().add(new DescriptionEntry(line, 8));
//						}
//
//						Text updateText = Text.translatable("modmenu.updateText", VersionUtil.stripPrefix(mod.getModrinthData().versionNumber()), MODRINTH_TEXT)
//							.formatted(Formatting.BLUE)
//							.formatted(Formatting.UNDERLINE);
//
//						String versionLink = "https://modrinth.com/project/%s/version/%s".formatted(mod.getModrinthData().projectId(), mod.getModrinthData().versionId());
//
//						for (OrderedText line : textRenderer.wrapLines(updateText, wrapWidth - 16)) {
//							children().add(new LinkEntry(line, versionLink, 8));
//						}
//					}
//					if (mod.getChildHasUpdate()) {
//						children().add(emptyEntry);
//
//						int index = 0;
//						for (OrderedText line : textRenderer.wrapLines(CHILD_HAS_UPDATE_TEXT, wrapWidth - 11)) {
//							DescriptionEntry entry = new DescriptionEntry(line);
//							if (index == 0) entry.setUpdateTextEntry();
//
//							children().add(entry);
//							index += 1;
//						}
//					}
//				}

					Map<String, String> links = mod.getLinks();
					String sourceLink = mod.getSource();
					if ((!links.isEmpty() || sourceLink != null) && !ModMenuConfig.HIDE_MOD_LINKS.getValue()) {
						method_25396().add(emptyEntry);

						for (class_5481 line : textRenderer.method_1728(LINKS_TEXT, wrapWidth)) {
							method_25396().add(new DescriptionEntry(line));
						}

						if (sourceLink != null) {
							int indent = 8;
							for (class_5481 line : textRenderer.method_1728(SOURCE_TEXT, wrapWidth - 16)) {

								method_25396().add(new LinkEntry(line, sourceLink, indent));
								indent = 16;
							}
						}

						links.forEach((key, value) -> {
							int indent = 8;
							for (class_5481 line : textRenderer.method_1728(class_2561.method_43471(key).method_27692(class_124.field_1078).method_27692(class_124.field_1073), wrapWidth - 16)) {
								method_25396().add(new LinkEntry(line, value, indent));
								indent = 16;
							}
						});


					Set<String> licenses = mod.getLicense();
					if (!ModMenuConfig.HIDE_MOD_LICENSE.getValue() && !licenses.isEmpty()) {
						method_25396().add(emptyEntry);

						for (class_5481 line : textRenderer.method_1728(LICENSE_TEXT, wrapWidth)) {
							method_25396().add(new DescriptionEntry(line));
						}

						for (String license : licenses) {
							int indent = 8;
							for (class_5481 line : textRenderer.method_1728(class_2561.method_43470(license), wrapWidth - 16)) {
								method_25396().add(new DescriptionEntry(line, indent));
								indent = 16;
							}
						}
					}
				}

				if (!ModMenuConfig.HIDE_MOD_CREDITS.getValue()) {
					if ("minecraft".equals(mod.getId())) {
						method_25396().add(emptyEntry);

						for (class_5481 line : textRenderer.method_1728(VIEW_CREDITS_TEXT, wrapWidth)) {
							method_25396().add(new MojangCreditsEntry(line));
						}
					} else if (!"java".equals(mod.getId())) {
						List<String> credits = mod.getCredits();
						if (!credits.isEmpty()) {
							method_25396().add(emptyEntry);

							for (class_5481 line : textRenderer.method_1728(CREDITS_TEXT, wrapWidth)) {
								method_25396().add(new DescriptionEntry(line));
							}

							for (String credit : credits) {
								int indent = 8;
								for (class_5481 line : textRenderer.method_1728(class_2561.method_43470(credit), wrapWidth - 16)) {
									method_25396().add(new DescriptionEntry(line, indent));
									indent = 16;
								}
							}
						}
					}
				}
				}
			}
		}

	}

	@Override
	public void method_25311(class_332 drawContext, int mouseX, int mouseY, float delta) {
		if(parent.getSelectedEntry() != lastSelected){
			rebuildUI();
		}
		this.method_49603(drawContext);
		super.method_25311(drawContext, mouseX, mouseY, delta);
		drawContext.method_44380();
	}

	protected class DescriptionEntry extends class_4265.class_4266<DescriptionEntry> {
		protected class_5481 text;
		protected int indent;
		public boolean updateTextEntry = false;

		public DescriptionEntry(class_5481 text, int indent) {
			this.text = text;
			this.indent = indent;
		}

		public DescriptionEntry(class_5481 text) {
			this(text, 0);
		}

		public DescriptionEntry setUpdateTextEntry() {
			this.updateTextEntry = true;
			return this;
		}

		@Override
		public void method_25343(class_332 DrawContext, int index, int y, int x, int itemWidth, int itemHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
//			if (updateTextEntry) {
//				UpdateAvailableBadge.renderBadge(DrawContext, x + indent, y);
//				x += 11;
//			}
			DrawContext.method_35720(textRenderer, text, x + indent, y, 0xFFAAAAAA);
		}

		@Override
		public List<? extends class_364> method_25396() {
			return Collections.emptyList();
		}

		@Override
		public List<? extends class_6379> method_37025() {
			return Collections.emptyList();
		}
	}

	protected class MojangCreditsEntry extends DescriptionEntry {
		public MojangCreditsEntry(class_5481 text) {
			super(text);
		}

		@Override
		public boolean method_25402(double mouseX, double mouseY, int button) {
			if (method_25405(mouseX, mouseY)) {
				field_22740.method_1507(new MinecraftCredits());
			}
			return super.method_25402(mouseX, mouseY, button);
		}

		class MinecraftCredits extends class_8219 {
			public MinecraftCredits() {
				super(parent);
			}
		}
	}

	protected class LinkEntry extends DescriptionEntry {
		private final String link;

		public LinkEntry(class_5481 text, String link, int indent) {
			super(text, indent);
			this.link = link;
		}

		public LinkEntry(class_5481 text, String link) {
			this(text, link, 0);
		}

		@Override
		public boolean method_25402(double mouseX, double mouseY, int button) {
			if (method_25405(mouseX, mouseY)) {
				field_22740.method_1507(new class_407((open) -> {
					if (open) {
						class_156.method_668().method_670(link);
					}
					field_22740.method_1507(parent);
					parent.modList.setSelected(lastSelected);
				}, link, false));
			}
			return super.method_25402(mouseX, mouseY, button);
		}
	}

}
